/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.emitter.core;

import com.google.common.base.Preconditions;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.emitter.core.Emitter;
import io.druid.java.util.emitter.core.Event;
import java.io.IOException;
import java.util.List;

public class ComposingEmitter
implements Emitter {
    private static Logger log = new Logger(ComposingEmitter.class);
    private final List<Emitter> emitters;

    public ComposingEmitter(List<Emitter> emitters) {
        this.emitters = (List)Preconditions.checkNotNull(emitters, (Object)"null emitters");
    }

    @Override
    @LifecycleStart
    public void start() {
        log.info("Starting Composing Emitter.", new Object[0]);
        for (Emitter e : this.emitters) {
            log.info("Starting emitter %s.", e.getClass().getName());
            e.start();
        }
    }

    @Override
    public void emit(Event event) {
        for (Emitter e : this.emitters) {
            e.emit(event);
        }
    }

    @Override
    public void flush() throws IOException {
        boolean fail = false;
        log.info("Flushing Composing Emitter.", new Object[0]);
        for (Emitter e : this.emitters) {
            try {
                log.info("Flushing emitter %s.", e.getClass().getName());
                e.flush();
            }
            catch (IOException ex) {
                log.error(ex, "Failed to flush emitter [%s]", e.getClass().getName());
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to flush one or more emitters");
        }
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        boolean fail = false;
        log.info("Closing Composing Emitter.", new Object[0]);
        for (Emitter e : this.emitters) {
            try {
                log.info("Closing emitter %s.", e.getClass().getName());
                e.close();
            }
            catch (IOException ex) {
                log.error(ex, "Failed to close emitter [%s]", e.getClass().getName());
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to close one or more emitters");
        }
    }

    public String toString() {
        return "ComposingEmitter{emitters=" + this.emitters + '}';
    }
}

