/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.guava.nary;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.druid.java.util.common.guava.nary.BinaryFn;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SortedMergeIterator<InType, OutType>
implements Iterator<OutType> {
    private final PeekingIterator<InType> lhs;
    private final PeekingIterator<InType> rhs;
    private final Comparator<InType> comparator;
    private final BinaryFn<InType, InType, OutType> fn;

    public static <InType, OutType> SortedMergeIterator<InType, OutType> create(Iterator<InType> lhs, Iterator<InType> rhs, Comparator<InType> comparator, BinaryFn<InType, InType, OutType> fn) {
        return new SortedMergeIterator<InType, OutType>(lhs, rhs, comparator, fn);
    }

    public SortedMergeIterator(Iterator<InType> lhs, Iterator<InType> rhs, Comparator<InType> comparator, BinaryFn<InType, InType, OutType> fn) {
        this.lhs = Iterators.peekingIterator(lhs);
        this.rhs = Iterators.peekingIterator(rhs);
        this.comparator = comparator;
        this.fn = fn;
    }

    @Override
    public boolean hasNext() {
        return this.lhs.hasNext() || this.rhs.hasNext();
    }

    @Override
    public OutType next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.lhs.hasNext()) {
            return this.fn.apply(null, this.rhs.next());
        }
        if (!this.rhs.hasNext()) {
            return this.fn.apply(this.lhs.next(), null);
        }
        int compared = this.comparator.compare(this.lhs.peek(), this.rhs.peek());
        if (compared < 0) {
            return this.fn.apply(this.lhs.next(), null);
        }
        if (compared == 0) {
            return this.fn.apply(this.lhs.next(), this.rhs.next());
        }
        return this.fn.apply(null, this.rhs.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

