/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.guava;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class Comparators {
    private static final Ordering<Object> ALWAYS_EQUAL = new Ordering<Object>(){

        public int compare(@Nullable Object left, @Nullable Object right) {
            return 0;
        }
    };
    private static final Ordering NATURAL_NULLS_FIRST = Ordering.natural().nullsFirst();
    private static final Comparator<Interval> INTERVAL_BY_START_THEN_END = new Comparator<Interval>(){
        private final DateTimeComparator dateTimeComp = DateTimeComparator.getInstance();

        @Override
        public int compare(Interval lhs, Interval rhs) {
            if (lhs.getChronology().equals(rhs.getChronology())) {
                int compare = Longs.compare((long)lhs.getStartMillis(), (long)rhs.getStartMillis());
                if (compare == 0) {
                    return Longs.compare((long)lhs.getEndMillis(), (long)rhs.getEndMillis());
                }
                return compare;
            }
            int retVal = this.dateTimeComp.compare((Object)lhs.getStart(), (Object)rhs.getStart());
            if (retVal == 0) {
                retVal = this.dateTimeComp.compare((Object)lhs.getEnd(), (Object)rhs.getEnd());
            }
            return retVal;
        }
    };
    private static final Comparator<Interval> INTERVAL_BY_END_THEN_START = new Comparator<Interval>(){
        private final DateTimeComparator dateTimeComp = DateTimeComparator.getInstance();

        @Override
        public int compare(Interval lhs, Interval rhs) {
            if (lhs.getChronology().equals(rhs.getChronology())) {
                int compare = Longs.compare((long)lhs.getEndMillis(), (long)rhs.getEndMillis());
                if (compare == 0) {
                    return Longs.compare((long)lhs.getStartMillis(), (long)rhs.getStartMillis());
                }
                return compare;
            }
            int retVal = this.dateTimeComp.compare((Object)lhs.getEnd(), (Object)rhs.getEnd());
            if (retVal == 0) {
                retVal = this.dateTimeComp.compare((Object)lhs.getStart(), (Object)rhs.getStart());
            }
            return retVal;
        }
    };

    public static <T> Ordering<T> alwaysEqual() {
        return ALWAYS_EQUAL;
    }

    public static <T extends Comparable<? super T>> Ordering<T> naturalNullsFirst() {
        return NATURAL_NULLS_FIRST;
    }

    public static <T> Comparator<T> inverse(final Comparator<T> baseComp) {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t1) {
                return baseComp.compare(t1, t);
            }
        };
    }

    @Deprecated
    public static <T extends Comparable> Comparator<T> comparable() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t1) {
                return t.compareTo(t1);
            }
        };
    }

    @Deprecated
    public static Comparator<Interval> intervals() {
        return Comparators.intervalsByStartThenEnd();
    }

    public static Comparator<Interval> intervalsByStartThenEnd() {
        return INTERVAL_BY_START_THEN_END;
    }

    public static Comparator<Interval> intervalsByEndThenStart() {
        return INTERVAL_BY_END_THEN_START;
    }
}

