/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.granularity;

import io.druid.java.util.common.IAE;
import io.druid.java.util.common.granularity.AllGranularity;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.granularity.NoneGranularity;
import io.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;

public enum GranularityType {
    SECOND("'dt'=yyyy-MM-dd-HH-mm-ss", "'y'=yyyy/'m'=MM/'d'=dd/'h'=HH/'m'=mm/'s'=ss", "'y'=yyyy/'m'=MM/'d'=dd/'H'=HH/'M'=mm/'S'=ss", 6, "PT1S"),
    MINUTE("'dt'=yyyy-MM-dd-HH-mm", "'y'=yyyy/'m'=MM/'d'=dd/'h'=HH/'m'=mm", "'y'=yyyy/'m'=MM/'d'=dd/'H'=HH/'M'=mm", 5, "PT1M"),
    FIVE_MINUTE(MINUTE, "PT5M"),
    TEN_MINUTE(MINUTE, "PT10M"),
    FIFTEEN_MINUTE(MINUTE, "PT15M"),
    THIRTY_MINUTE(MINUTE, "PT30M"),
    HOUR("'dt'=yyyy-MM-dd-HH", "'y'=yyyy/'m'=MM/'d'=dd/'h'=HH", "'y'=yyyy/'m'=MM/'d'=dd/'H'=HH", 4, "PT1H"),
    SIX_HOUR(HOUR, "PT6H"),
    DAY("'dt'=yyyy-MM-dd", "'y'=yyyy/'m'=MM/'d'=dd", "'y'=yyyy/'m'=MM/'d'=dd", 3, "P1D"),
    WEEK(DAY, "P1W"),
    MONTH("'dt'=yyyy-MM", "'y'=yyyy/'m'=MM", "'y'=yyyy/'m'=MM", 2, "P1M"),
    QUARTER(MONTH, "P3M"),
    YEAR("'dt'=yyyy", "'y'=yyyy", "'y'=yyyy", 1, "P1Y"),
    ALL(new AllGranularity()),
    NONE(new NoneGranularity());

    private final String hiveFormat;
    private final String lowerDefaultFormat;
    private final String defaultFormat;
    private final int dateValuePositions;
    private final Period period;
    private final Granularity defaultGranularity;

    private GranularityType(Granularity specialGranularity) {
        this.hiveFormat = null;
        this.lowerDefaultFormat = null;
        this.defaultFormat = null;
        this.dateValuePositions = 0;
        this.period = null;
        this.defaultGranularity = specialGranularity;
    }

    private GranularityType(String hiveFormat, String lowerDefaultFormat, String defaultFormat, int dateValuePositions, String period) {
        this.hiveFormat = hiveFormat;
        this.lowerDefaultFormat = lowerDefaultFormat;
        this.defaultFormat = defaultFormat;
        this.dateValuePositions = dateValuePositions;
        this.period = new Period((Object)period);
        this.defaultGranularity = new PeriodGranularity(this.period, null, null);
    }

    private GranularityType(GranularityType granularityType, String period) {
        this(granularityType.getHiveFormat(), granularityType.getLowerDefaultFormat(), granularityType.getDefaultFormat(), granularityType.dateValuePositions, period);
    }

    Granularity create(DateTime origin, DateTimeZone tz) {
        if (this.period != null && (origin != null || tz != null)) {
            return new PeriodGranularity(this.period, origin, tz);
        }
        return this.defaultGranularity;
    }

    public Granularity getDefaultGranularity() {
        return this.defaultGranularity;
    }

    public DateTime getDateTime(Integer[] vals) {
        if (this.dateValuePositions == 0) {
            return null;
        }
        for (int i = 1; i <= this.dateValuePositions; ++i) {
            if (vals[i] != null) continue;
            return null;
        }
        return new DateTime(vals[1].intValue(), this.dateValuePositions >= 2 ? vals[2] : 1, this.dateValuePositions >= 3 ? vals[3] : 1, this.dateValuePositions >= 4 ? vals[4] : 0, this.dateValuePositions >= 5 ? vals[5] : 0, this.dateValuePositions >= 6 ? vals[6] : 0, 0, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static boolean isStandard(Granularity granularity) {
        GranularityType[] values;
        for (GranularityType value : values = GranularityType.values()) {
            if (!value.getDefaultGranularity().equals(granularity)) continue;
            return true;
        }
        return false;
    }

    public static GranularityType fromPeriod(Period period) {
        int[] vals = period.getValues();
        int index = -1;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == 0) continue;
            if (index < 0) {
                index = i;
                continue;
            }
            throw new IAE("Granularity is not supported. [%s]", period);
        }
        switch (index) {
            case 0: {
                return YEAR;
            }
            case 1: {
                if (vals[index] == 3) {
                    return QUARTER;
                }
                if (vals[index] != 1) break;
                return MONTH;
            }
            case 2: {
                return WEEK;
            }
            case 3: {
                return DAY;
            }
            case 4: {
                if (vals[index] == 6) {
                    return SIX_HOUR;
                }
                if (vals[index] != 1) break;
                return HOUR;
            }
            case 5: {
                if (vals[index] == 30) {
                    return THIRTY_MINUTE;
                }
                if (vals[index] == 15) {
                    return FIFTEEN_MINUTE;
                }
                if (vals[index] == 10) {
                    return TEN_MINUTE;
                }
                if (vals[index] == 5) {
                    return FIVE_MINUTE;
                }
                if (vals[index] != 1) break;
                return MINUTE;
            }
            case 6: {
                return SECOND;
            }
        }
        throw new IAE("Granularity is not supported. [%s]", period);
    }

    public String getHiveFormat() {
        return this.hiveFormat;
    }

    public String getLowerDefaultFormat() {
        return this.lowerDefaultFormat;
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }
}

