/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.indexer.partitions.PartitionsSpec;

public abstract class AbstractPartitionsSpec
implements PartitionsSpec {
    private static final double DEFAULT_OVERSIZE_THRESHOLD = 1.5;
    private static final long DEFAULT_TARGET_PARTITION_SIZE = -1L;
    private final long targetPartitionSize;
    private final long maxPartitionSize;
    private final boolean assumeGrouped;
    private final int numShards;

    public AbstractPartitionsSpec(Long targetPartitionSize, Long maxPartitionSize, Boolean assumeGrouped, Integer numShards) {
        this.targetPartitionSize = targetPartitionSize == null ? -1L : targetPartitionSize;
        this.maxPartitionSize = maxPartitionSize == null ? (long)((double)this.targetPartitionSize * 1.5) : maxPartitionSize;
        this.assumeGrouped = assumeGrouped == null ? false : assumeGrouped;
        this.numShards = numShards == null ? -1 : numShards;
        Preconditions.checkArgument((this.targetPartitionSize == -1L || this.numShards == -1 ? 1 : 0) != 0, (Object)"targetPartitionsSize and shardCount both cannot be set");
    }

    @Override
    @JsonProperty
    public long getTargetPartitionSize() {
        return this.targetPartitionSize;
    }

    @Override
    @JsonProperty
    public long getMaxPartitionSize() {
        return this.maxPartitionSize;
    }

    @Override
    @JsonProperty
    public boolean isAssumeGrouped() {
        return this.assumeGrouped;
    }

    @Override
    public boolean isDeterminingPartitions() {
        return this.targetPartitionSize > 0L;
    }

    @Override
    public int getNumShards() {
        return this.numShards;
    }
}

