/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import io.druid.timeline.partition.PartitionChunk;

public class LinearPartitionChunk<T>
implements PartitionChunk<T> {
    private final int chunkNumber;
    private final T object;

    public LinearPartitionChunk(int chunkNumber, T object) {
        this.chunkNumber = chunkNumber;
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public boolean abuts(PartitionChunk<T> chunk) {
        return true;
    }

    public boolean isStart() {
        return true;
    }

    public boolean isEnd() {
        return true;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public int compareTo(PartitionChunk<T> chunk) {
        if (chunk instanceof LinearPartitionChunk) {
            LinearPartitionChunk linearChunk = (LinearPartitionChunk)chunk;
            return Integer.compare(this.chunkNumber, linearChunk.chunkNumber);
        }
        throw new IllegalArgumentException("Cannot compare against something that is not a LinearPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((LinearPartitionChunk)o) == 0;
    }

    public int hashCode() {
        return this.chunkNumber;
    }
}

