/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.druid.java.util.common.StringUtils;
import java.util.Map;

public class MetadataStorageTablesConfig {
    public static final String TASK_ENTRY_TYPE = "task";
    private static final String DEFAULT_BASE = "druid";
    private final Map<String, String> entryTables = Maps.newHashMap();
    private final Map<String, String> logTables = Maps.newHashMap();
    private final Map<String, String> lockTables = Maps.newHashMap();
    @JsonProperty(value="base")
    private final String base;
    @JsonProperty(value="dataSource")
    private final String dataSourceTable;
    @JsonProperty(value="pendingSegments")
    private final String pendingSegmentsTable;
    @JsonProperty(value="segments")
    private final String segmentsTable;
    @JsonProperty(value="rules")
    private final String rulesTable;
    @JsonProperty(value="config")
    private final String configTable;
    @JsonProperty(value="tasks")
    private final String tasksTable;
    @JsonProperty(value="taskLog")
    private final String taskLogTable;
    @JsonProperty(value="taskLock")
    private final String taskLockTable;
    @JsonProperty(value="audit")
    private final String auditTable;
    @JsonProperty(value="supervisors")
    private final String supervisorTable;

    public static MetadataStorageTablesConfig fromBase(String base) {
        return new MetadataStorageTablesConfig(base, null, null, null, null, null, null, null, null, null, null);
    }

    @JsonCreator
    public MetadataStorageTablesConfig(@JsonProperty(value="base") String base, @JsonProperty(value="dataSource") String dataSourceTable, @JsonProperty(value="pendingSegments") String pendingSegmentsTable, @JsonProperty(value="segments") String segmentsTable, @JsonProperty(value="rules") String rulesTable, @JsonProperty(value="config") String configTable, @JsonProperty(value="tasks") String tasksTable, @JsonProperty(value="taskLog") String taskLogTable, @JsonProperty(value="taskLock") String taskLockTable, @JsonProperty(value="audit") String auditTable, @JsonProperty(value="supervisors") String supervisorTable) {
        this.base = base == null ? DEFAULT_BASE : base;
        this.dataSourceTable = this.makeTableName(dataSourceTable, "dataSource");
        this.pendingSegmentsTable = this.makeTableName(pendingSegmentsTable, "pendingSegments");
        this.segmentsTable = this.makeTableName(segmentsTable, "segments");
        this.rulesTable = this.makeTableName(rulesTable, "rules");
        this.configTable = this.makeTableName(configTable, "config");
        this.tasksTable = this.makeTableName(tasksTable, "tasks");
        this.taskLogTable = this.makeTableName(taskLogTable, "tasklogs");
        this.taskLockTable = this.makeTableName(taskLockTable, "tasklocks");
        this.entryTables.put(TASK_ENTRY_TYPE, this.tasksTable);
        this.logTables.put(TASK_ENTRY_TYPE, this.taskLogTable);
        this.lockTables.put(TASK_ENTRY_TYPE, this.taskLockTable);
        this.auditTable = this.makeTableName(auditTable, "audit");
        this.supervisorTable = this.makeTableName(supervisorTable, "supervisors");
    }

    private String makeTableName(String explicitTableName, String defaultSuffix) {
        if (explicitTableName == null) {
            if (this.base == null) {
                return null;
            }
            return StringUtils.format((String)"%s_%s", (Object[])new Object[]{this.base, defaultSuffix});
        }
        return explicitTableName;
    }

    public String getBase() {
        return this.base;
    }

    public String getDataSourceTable() {
        return this.dataSourceTable;
    }

    public String getPendingSegmentsTable() {
        return this.pendingSegmentsTable;
    }

    public String getSegmentsTable() {
        return this.segmentsTable;
    }

    public String getRulesTable() {
        return this.rulesTable;
    }

    public String getConfigTable() {
        return this.configTable;
    }

    public String getEntryTable(String entryType) {
        return this.entryTables.get(entryType);
    }

    public String getLogTable(String entryType) {
        return this.logTables.get(entryType);
    }

    public String getLockTable(String entryType) {
        return this.lockTables.get(entryType);
    }

    public String getTaskEntryType() {
        return TASK_ENTRY_TYPE;
    }

    public String getAuditTable() {
        return this.auditTable;
    }

    public String getSupervisorTable() {
        return this.supervisorTable;
    }

    public String getTasksTable() {
        return this.tasksTable;
    }

    public String getTaskLogTable() {
        return this.taskLogTable;
    }

    public String getTaskLockTable() {
        return this.taskLockTable;
    }
}

