/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.druid.java.util.common.guava.FunctionalIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class OrderedMergeIterator<T>
implements Iterator<T> {
    private final PriorityQueue<PeekingIterator<T>> firstElementComparedPQueue;
    private PeekingIterator<PeekingIterator<T>> iterOfIterators;
    private final Comparator<T> comparator;

    public OrderedMergeIterator(final Comparator<T> comparator, Iterator<Iterator<T>> iterators) {
        this.comparator = comparator;
        this.firstElementComparedPQueue = new PriorityQueue(16, new Comparator<PeekingIterator<T>>(){

            @Override
            public int compare(PeekingIterator<T> lhs, PeekingIterator<T> rhs) {
                return comparator.compare(lhs.peek(), rhs.peek());
            }
        });
        this.iterOfIterators = Iterators.peekingIterator((Iterator)FunctionalIterator.create(iterators).filter(new Predicate<Iterator<T>>(){

            public boolean apply(Iterator<T> input) {
                return input.hasNext();
            }
        }).transform(new Function<Iterator<T>, PeekingIterator<T>>(){

            public PeekingIterator<T> apply(Iterator<T> input) {
                return Iterators.peekingIterator(input);
            }
        }));
    }

    @Override
    public boolean hasNext() {
        return !this.firstElementComparedPQueue.isEmpty() || this.iterOfIterators.hasNext();
    }

    @Override
    public T next() {
        Object iterItersValue;
        Object pQueueValue;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PeekingIterator littleIt = !this.iterOfIterators.hasNext() ? (PeekingIterator)this.firstElementComparedPQueue.remove() : (this.firstElementComparedPQueue.isEmpty() ? (PeekingIterator)this.iterOfIterators.next() : (this.comparator.compare(pQueueValue = this.firstElementComparedPQueue.peek().peek(), iterItersValue = ((PeekingIterator)this.iterOfIterators.peek()).peek()) <= 0 ? (PeekingIterator)this.firstElementComparedPQueue.remove() : (PeekingIterator)this.iterOfIterators.next()));
        Object retVal = littleIt.next();
        if (littleIt.hasNext()) {
            this.firstElementComparedPQueue.add(littleIt);
        }
        return (T)retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

