/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.druid.collections.BlockingPool;
import io.druid.collections.ReferenceCountingResourceHolder;
import io.druid.java.util.common.ISE;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultBlockingPool<T>
implements BlockingPool<T> {
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private final ArrayDeque<T> objects;
    private final ReentrantLock lock;
    private final Condition notEnough;
    private final int maxSize;

    public DefaultBlockingPool(Supplier<T> generator, int limit) {
        this.objects = new ArrayDeque(limit);
        this.maxSize = limit;
        for (int i = 0; i < limit; ++i) {
            this.objects.add(generator.get());
        }
        this.lock = new ReentrantLock();
        this.notEnough = this.lock.newCondition();
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @VisibleForTesting
    public int getPoolSize() {
        return this.objects.size();
    }

    @Override
    public ReferenceCountingResourceHolder<T> take(long timeoutMs) {
        Preconditions.checkArgument((timeoutMs >= 0L ? 1 : 0) != 0, (String)"timeoutMs must be a non-negative value, but was [%s]", (Object[])new Object[]{timeoutMs});
        this.checkInitialized();
        try {
            return this.wrapObject(timeoutMs > 0L ? this.pollObject(timeoutMs) : this.pollObject());
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ReferenceCountingResourceHolder<T> take() {
        this.checkInitialized();
        try {
            return this.wrapObject(this.takeObject());
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ReferenceCountingResourceHolder<T> wrapObject(final T theObject) {
        return theObject == null ? null : new ReferenceCountingResourceHolder<T>(theObject, new Closeable(){

            @Override
            public void close() throws IOException {
                DefaultBlockingPool.this.offer(theObject);
            }
        });
    }

    private T pollObject() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T t = this.objects.isEmpty() ? null : (T)this.objects.pop();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T pollObject(long timeoutMs) throws InterruptedException {
        long nanos = TIME_UNIT.toNanos(timeoutMs);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.objects.isEmpty()) {
                if (nanos <= 0L) {
                    T t = null;
                    return t;
                }
                nanos = this.notEnough.awaitNanos(nanos);
            }
            T t = this.objects.pop();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private T takeObject() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.objects.isEmpty()) {
                this.notEnough.await();
            }
            T t = this.objects.pop();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ReferenceCountingResourceHolder<List<T>> takeBatch(int elementNum, long timeoutMs) {
        Preconditions.checkArgument((timeoutMs >= 0L ? 1 : 0) != 0, (String)"timeoutMs must be a non-negative value, but was [%s]", (Object[])new Object[]{timeoutMs});
        this.checkInitialized();
        try {
            return this.wrapObjects(timeoutMs > 0L ? this.pollObjects(elementNum, timeoutMs) : this.pollObjects(elementNum));
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ReferenceCountingResourceHolder<List<T>> takeBatch(int elementNum) {
        this.checkInitialized();
        try {
            return this.wrapObjects(this.takeObjects(elementNum));
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ReferenceCountingResourceHolder<List<T>> wrapObjects(final List<T> theObjects) {
        return theObjects == null ? null : new ReferenceCountingResourceHolder<List<List<List<List<T>>>>>(theObjects, new Closeable(){

            @Override
            public void close() throws IOException {
                DefaultBlockingPool.this.offerBatch(theObjects);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> pollObjects(int elementNum) throws InterruptedException {
        ArrayList list = Lists.newArrayListWithCapacity((int)elementNum);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.objects.size() < elementNum) {
                List<T> list2 = null;
                return list2;
            }
            for (int i = 0; i < elementNum; ++i) {
                list.add(this.objects.pop());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> pollObjects(int elementNum, long timeoutMs) throws InterruptedException {
        long nanos = TIME_UNIT.toNanos(timeoutMs);
        ArrayList list = Lists.newArrayListWithCapacity((int)elementNum);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.objects.size() < elementNum) {
                if (nanos <= 0L) {
                    List<T> list2 = null;
                    return list2;
                }
                nanos = this.notEnough.awaitNanos(nanos);
            }
            for (int i = 0; i < elementNum; ++i) {
                list.add(this.objects.pop());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> takeObjects(int elementNum) throws InterruptedException {
        ArrayList list = Lists.newArrayListWithCapacity((int)elementNum);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.objects.size() < elementNum) {
                this.notEnough.await();
            }
            for (int i = 0; i < elementNum; ++i) {
                list.add(this.objects.pop());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private void checkInitialized() {
        Preconditions.checkState((this.maxSize > 0 ? 1 : 0) != 0, (Object)"Pool was initialized with limit = 0, there are no objects to take.");
    }

    private void offer(T theObject) {
        block4: {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.objects.size() < this.maxSize) {
                    this.objects.push(theObject);
                    this.notEnough.signal();
                    break block4;
                }
                throw new ISE("Cannot exceed pre-configured maximum size", new Object[0]);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerBatch(List<T> offers) {
        block5: {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.objects.size() + offers.size() <= this.maxSize) {
                    for (T offer : offers) {
                        this.objects.push(offer);
                    }
                    this.notEnough.signal();
                    break block5;
                }
                throw new ISE("Cannot exceed pre-configured maximum size", new Object[0]);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

