/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.unidata.util.StringUtil;

public class TableParser {
    private List<Field> fields = new ArrayList<Field>();
    static String testName = "/optional/nj22/tables/STNDB.TXT";
    static String testName3 = "/resources/nj22/tables/nexrad.tbl";
    static String testRepeat = "C:\\data\\ghcnm\\ghcnm.v3.0.0-beta1.20101207.qae.dat";

    public static List<Record> readTable(String urlString, String format, int maxLines) throws IOException, NumberFormatException {
        InputStream ios;
        if (urlString.startsWith("http:")) {
            URL url = new URL(urlString);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(urlString);
        }
        return TableParser.readTable(ios, format, maxLines);
    }

    public static List<Record> readTable(InputStream ios, String format, int maxLines) throws IOException, NumberFormatException {
        TableParser parser = new TableParser(format);
        List<Record> result = parser.readAllRecords(ios, maxLines);
        ios.close();
        return result;
    }

    public TableParser(String format) throws IOException, NumberFormatException {
        int start = 0;
        StringTokenizer stoker = new StringTokenizer(format, " ,");
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            Class type = String.class;
            char last = tok.charAt(tok.length() - 1);
            if (last == 'i') {
                type = Integer.TYPE;
            }
            if (last == 'd') {
                type = Double.TYPE;
            }
            if (last == 'L') {
                type = Long.TYPE;
            }
            if (type != String.class) {
                tok = tok.substring(0, tok.length() - 1);
            }
            int end = Integer.parseInt(tok);
            this.fields.add(new Field(start, end, type));
            start = end;
        }
    }

    public Field getField(int fldno) {
        return this.fields.get(fldno);
    }

    public int getNumberOfFields() {
        return this.fields.size();
    }

    public List<Record> readAllRecords(InputStream ios, int maxLines) throws IOException, NumberFormatException {
        String line;
        ArrayList<Record> records = new ArrayList<Record>();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        int count = 0;
        while ((maxLines < 0 || count < maxLines) && (line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            Record r = Record.make(line, this.fields);
            if (r != null) {
                records.add(r);
            }
            ++count;
        }
        return records;
    }

    public Record readRecord(String line) throws IOException, NumberFormatException {
        if (line == null) {
            return null;
        }
        if (line.startsWith("#")) {
            return null;
        }
        if (line.trim().length() == 0) {
            return null;
        }
        return Record.make(line, this.fields);
    }

    public DerivedField addDerivedField(Field from, Transform transform, Class type) {
        DerivedField fld = new DerivedField(from, transform, type);
        this.fields.add(fld);
        return fld;
    }

    public static void main2(String[] args) throws IOException {
        Class<TableParser> c = TableParser.class;
        InputStream is = c.getResourceAsStream(testName3);
        List<Record> recs = TableParser.readTable(is, "3,15,54,60d,67d,73d", 50000);
        for (int i = 0; i < recs.size(); ++i) {
            Record record = recs.get(i);
            for (int j = 0; j < record.values.size(); ++j) {
                Object s = record.values.get(j);
                System.out.print(" " + s.toString());
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws IOException {
        List<Record> recs = TableParser.readTable(testRepeat, "11L,15i,19,(24i,25,26,27)*10", 5);
        for (int i = 0; i < recs.size(); ++i) {
            Record record = recs.get(i);
            for (int j = 0; j < record.values.size(); ++j) {
                Object s = record.values.get(j);
                System.out.print("; " + s.toString());
            }
            System.out.println();
        }
    }

    public static class Record {
        private List<Object> values = new ArrayList<Object>();

        static Record make(String line, List fields) {
            try {
                Record r = new Record();
                for (Object field : fields) {
                    Field f = (Field)field;
                    r.values.add(f.parse(line));
                }
                return r;
            }
            catch (NumberFormatException e) {
                System.out.printf("Bad line=%s %n", line);
                return null;
            }
        }

        public int nfields() {
            return this.values.size();
        }

        public Object get(int k) {
            return this.values.get(k);
        }

        public void toString(Formatter f) {
            for (int j = 0; j < this.values.size(); ++j) {
                Object s = this.values.get(j);
                f.format(" %s,", s.toString());
            }
            f.format("%n", new Object[0]);
        }
    }

    public static interface Transform {
        public Object derive(Object var1);
    }

    public class DerivedField
    extends Field {
        Field from;
        Transform transform;

        DerivedField(Field from, Transform transform, Class type) {
            this.from = from;
            this.transform = transform;
            this.type = type;
        }

        @Override
        protected Object parse(String line, int start, int end) throws NumberFormatException {
            Object org = this.from.parse(line);
            return this.transform.derive(org);
        }
    }

    public class Field {
        int start;
        int end;
        Class type;
        boolean hasScale = false;
        float scale;

        Field(int start, int end, Class type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        protected Field() {
        }

        public Object parse(String line) throws NumberFormatException {
            return this.parse(line, this.start, this.end);
        }

        public Object parse(String line, int offset) throws NumberFormatException {
            return this.parse(line, this.start + offset, this.end + offset);
        }

        protected Object parse(String line, int start, int end) throws NumberFormatException {
            String svalue;
            String string = svalue = end > line.length() ? line.substring(start) : line.substring(start, end);
            if (this.type == String.class) {
                return svalue;
            }
            try {
                boolean isBlank;
                svalue = StringUtil.remove((String)svalue, (int)32);
                boolean bl = isBlank = svalue.trim().length() == 0;
                if (this.type == Double.TYPE) {
                    return isBlank ? 0.0 : new Double(svalue);
                }
                if (this.type == Integer.TYPE) {
                    Integer result = isBlank ? 0 : new Integer(svalue);
                    if (this.hasScale) {
                        return new Float((float)result.intValue() * this.scale);
                    }
                    return result;
                }
                if (this.type == Long.TYPE) {
                    return isBlank ? 0L : new Long(svalue);
                }
            }
            catch (NumberFormatException e) {
                System.out.printf("  [%d,%d) = <%s> %n", start, end, svalue);
                throw e;
            }
            return null;
        }

        public void setScale(float scale) {
            this.scale = scale;
            this.hasScale = true;
        }
    }
}

