/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.inventory.FeatureCollectionConfig;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.unidata.util.StringUtil;

@ThreadSafe
public class InvDatasetFcFmrc
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcFmrc.class);
    private static final String FMRC = "fmrc.ncd";
    private static final String BEST = "best.ncd";
    private static final String RUNS = "runs";
    private static final String RUN_NAME = "RUN_";
    private static final String RUN_TITLE = "Forecast Model Run";
    private static final String FORECAST = "forecast";
    private static final String FORECAST_NAME = "ConstantForecast_";
    private static final String FORECAST_TITLE = "Constant Forecast Date";
    private static final String OFFSET = "offset";
    private static final String OFFSET_NAME = "Offset_";
    private static final String OFFSET_TITLE = "Constant Forecast Offset";
    private final Fmrc fmrc;
    private final Set<FeatureCollectionConfig.FmrcDatasetType> wantDatasets;
    private InvService orgService;
    private InvService virtualService;

    public InvDatasetFcFmrc(InvDatasetImpl parent, String name, String path, FeatureType featureType, FeatureCollectionConfig config) {
        super(parent, name, path, featureType, config);
        this.tmi.setDataType(FeatureType.GRID);
        this.finish();
        Formatter errlog = new Formatter();
        try {
            this.fmrc = new Fmrc(this.dcm, config);
        }
        catch (Exception e) {
            throw new RuntimeException(errlog.toString());
        }
        this.wantDatasets = config.fmrcConfig.datasets;
    }

    @Override
    public void update() {
        this.fmrc.update();
    }

    @Override
    public void updateProto() {
        this.fmrc.updateProto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvDatasetFeatureCollection.State checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean checkInv = true;
            boolean checkProto = true;
            if (this.state == null) {
                this.orgService = this.getServiceDefault();
                this.virtualService = this.makeVirtualService(this.orgService);
            } else {
                this.fmrc.checkNeeded(false);
                checkInv = this.fmrc.checkInvState(this.state.lastInvChange);
                checkProto = this.fmrc.checkProtoState(this.state.lastProtoChange);
                if (!checkInv && !checkProto) {
                    return this.state;
                }
            }
            InvDatasetFeatureCollection.State localState = new InvDatasetFeatureCollection.State(this, this.state);
            if (checkProto) {
                ucar.nc2.dt.GridDataset gds = this.fmrc.getDataset2D(null);
                if (null != gds) {
                    localState.vars = MetadataExtractor.extractVariables(this, gds);
                    localState.gc = MetadataExtractor.extractGeospatial(gds);
                    localState.dateRange = MetadataExtractor.extractDateRange(gds);
                }
                localState.lastProtoChange = System.currentTimeMillis();
            }
            if (checkInv) {
                this.makeDatasets(localState);
                localState.lastInvChange = System.currentTimeMillis();
            }
            this.state = localState;
            return this.state;
        }
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String orgPath, URI baseURI) {
        logger.debug("FMRC make catalog for " + match + " " + baseURI);
        InvDatasetFeatureCollection.State localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(baseURI, localState);
                main.addService(this.virtualService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
                main.finish();
                return main;
            }
            if (match.equals(RUNS) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                return this.makeCatalogRuns(baseURI, localState);
            }
            if (match.equals(OFFSET) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                return this.makeCatalogOffsets(baseURI, localState);
            }
            if (match.equals(FORECAST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                return this.makeCatalogForecasts(baseURI, localState);
            }
            if (match.startsWith("files") && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Files)) {
                InvCatalogImpl files = localState.scan.makeCatalogForDirectory(orgPath, baseURI);
                if (files == null) {
                    return null;
                }
                files.addService(InvService.latest);
                files.addService(this.orgService);
                files.getDataset().getLocalMetadataInheritable().setServiceName(this.orgService.getName());
                files.finish();
                return files;
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, (Throwable)e);
        }
        return null;
    }

    private InvCatalogImpl makeCatalogRuns(URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(RUNS));
        InvCatalogImpl runCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(RUN_TITLE);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        runCatalog.addDataset(top);
        runCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeRunDatasets()) {
            top.addDataset(ds);
        }
        runCatalog.finish();
        return runCatalog;
    }

    private InvCatalogImpl makeCatalogOffsets(URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(OFFSET));
        InvCatalogImpl offCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        top.setName(OFFSET_TITLE);
        offCatalog.addDataset(top);
        offCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeOffsetDatasets()) {
            top.addDataset(ds);
        }
        offCatalog.finish();
        return offCatalog;
    }

    private InvCatalogImpl makeCatalogForecasts(URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(FORECAST));
        InvCatalogImpl foreCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(FORECAST_TITLE);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        foreCatalog.addDataset(top);
        foreCatalog.addService(this.virtualService);
        foreCatalog.addService(this.cdmrService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeForecastDatasets()) {
            top.addDataset(ds);
        }
        foreCatalog.finish();
        return foreCatalog;
    }

    private List<InvDatasetImpl> makeRunDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        DateFormatter formatter = new DateFormatter();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Date runDate : this.fmrc.getRunDates()) {
            String name = this.getName() + "_" + RUN_NAME + formatter.toDateTimeStringISO(runDate);
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + RUNS + "/" + name);
            nested.setID(id + "/" + RUNS + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from Run " + name);
            DateRange dr = this.fmrc.getDateRangeForRun(runDate);
            if (dr != null) {
                tm.setTimeCoverage(dr);
            }
            datasets.add(nested);
        }
        Collections.reverse(datasets);
        return datasets;
    }

    private List<InvDatasetImpl> makeOffsetDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (double offset : this.fmrc.getForecastOffsets()) {
            String name = this.getName() + "_" + OFFSET_NAME + offset + "hr";
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + OFFSET + "/" + name);
            nested.setID(id + "/" + OFFSET + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from the " + offset + " hour forecasts, across different model runs.");
            DateRange dr = this.fmrc.getDateRangeForOffset(offset);
            if (dr != null) {
                tm.setTimeCoverage(dr);
            }
            datasets.add(nested);
        }
        return datasets;
    }

    private List<InvDatasetImpl> makeForecastDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        DateFormatter formatter = new DateFormatter();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (Date forecastDate : this.fmrc.getForecastDates()) {
            String name = this.getName() + "_" + FORECAST_NAME + formatter.toDateTimeStringISO(forecastDate);
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + FORECAST + "/" + name);
            nested.setID(id + "/" + FORECAST + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data with the same forecast date, " + name + ", across different model runs.");
            tm.setTimeCoverage(new DateRange(forecastDate, forecastDate));
            datasets.add(nested);
        }
        return datasets;
    }

    private void makeDatasets(InvDatasetFeatureCollection.State localState) {
        ThreddsMetadata tm;
        String name;
        InvDatasetImpl ds;
        ArrayList<InvDataset> datasets = new ArrayList<InvDataset>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
            ds = new InvDatasetImpl(this, "Forecast Model Run Collection (2D time coordinates)");
            name = this.getName() + "_" + FMRC;
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Forecast Model Run Collection (2D time coordinates).");
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Best)) {
            ds = new InvDatasetImpl(this, "Best Time Series");
            name = this.getName() + "_" + BEST;
            name = StringUtil.replace((String)name, (char)' ', (String)"_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Best time series, taking the data from the most recent run available.");
            ds.finish();
            datasets.add(ds);
        }
        if (this.config.fmrcConfig.getBestDatasets() != null) {
            for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                InvDatasetImpl ds2 = new InvDatasetImpl(this, bd.name);
                String name2 = this.getName() + "_" + bd.name;
                name2 = StringUtil.replace((String)name2, (char)' ', (String)"_");
                ds2.setUrlPath(this.path + "/" + name2);
                ds2.setID(id + "/" + name2);
                ThreddsMetadata tm2 = ds2.getLocalMetadata();
                tm2.addDocumentation("summary", "Best time series, excluding offset hours less than " + bd.greaterThan);
                ds2.finish();
                datasets.add(ds2);
            }
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
            ds = new InvCatalogRef(this, RUN_TITLE, this.getCatalogHref(RUNS));
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
            ds = new InvCatalogRef(this, FORECAST_TITLE, this.getCatalogHref(FORECAST));
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
            ds = new InvCatalogRef(this, OFFSET_TITLE, this.getCatalogHref(OFFSET));
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Files) && this.topDirectory != null) {
            long olderThan = (long)(1000.0 * this.dcm.getOlderThanFilterInSecs());
            InvDatasetFeatureCollection.ScanFilter scanFilter = new InvDatasetFeatureCollection.ScanFilter(this.filter, olderThan);
            InvDatasetScan scanDataset = new InvDatasetScan((InvCatalogImpl)this.getParentCatalog(), (InvDatasetImpl)this, "File_Access", this.path + "/" + "files", this.topDirectory, scanFilter, true, "true", false, null, null, null);
            scanDataset.addService(this.orgService);
            ThreddsMetadata tmi = scanDataset.getLocalMetadataInheritable();
            tmi.setServiceName(this.orgService.getName());
            tmi.addDocumentation("summary", "Individual data file, which comprise the Forecast Model Run Collection.");
            tmi.setGeospatialCoverage(null);
            tmi.setTimeCoverage(null);
            scanDataset.setServiceName(this.orgService.getName());
            scanDataset.finish();
            datasets.add(scanDataset);
            localState.scan = scanDataset;
        }
        localState.datasets = datasets;
        this.datasets = datasets;
        this.finish();
    }

    @Override
    public ucar.nc2.dt.GridDataset getGridDataset(String matchPath) throws IOException {
        int pos = matchPath.indexOf(47);
        String wantType = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String wantName = pos > -1 ? matchPath.substring(pos + 1) : matchPath;
        String hasName = StringUtil.replace((String)this.name, (char)' ', (String)"_") + "_";
        try {
            if (wantType.equals("files")) {
                NetcdfDataset ncd = this.getNetcdfDataset(matchPath);
                return ncd == null ? null : new GridDataset(ncd);
            }
            if (wantName.equals(hasName + FMRC) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
                return this.fmrc.getDataset2D(null);
            }
            if (wantName.equals(hasName + BEST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Best)) {
                return this.fmrc.getDatasetBest();
            }
            if (wantType.equals(OFFSET) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                int pos1 = wantName.indexOf(OFFSET_NAME);
                int pos2 = wantName.indexOf("hr");
                if (pos1 < 0 || pos2 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + OFFSET_NAME.length(), pos2);
                double hour = Double.parseDouble(id);
                return this.fmrc.getConstantOffsetDataset(hour);
            }
            if (wantType.equals(RUNS) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                int pos1 = wantName.indexOf(RUN_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + RUN_NAME.length());
                DateFormatter formatter = new DateFormatter();
                Date date = formatter.getISODate(id);
                return this.fmrc.getRunTimeDataset(date);
            }
            if (wantType.equals(FORECAST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                int pos1 = wantName.indexOf(FORECAST_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + FORECAST_NAME.length());
                DateFormatter formatter = new DateFormatter();
                Date date = formatter.getISODate(id);
                return this.fmrc.getConstantForecastDataset(date);
            }
            if (this.config.fmrcConfig.getBestDatasets() != null) {
                for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                    if (!wantName.endsWith(bd.name)) continue;
                    return this.fmrc.getDatasetBest(bd);
                }
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }
}

