/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.impl;

import de.skuzzle.enforcer.restrictimports.api.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.impl.IOUtils;
import de.skuzzle.enforcer.restrictimports.impl.ImportMatcher;
import de.skuzzle.enforcer.restrictimports.model.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.model.Match;
import de.skuzzle.enforcer.restrictimports.model.PackagePattern;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;

final class SourceTreeAnalyzerImpl
implements SourceTreeAnalyzer {
    private final ImportMatcher matcher;
    private final IOUtils ioUtil;

    public SourceTreeAnalyzerImpl(ImportMatcher matcher, IOUtils ioUtils) {
        this.matcher = matcher;
        this.ioUtil = ioUtils;
    }

    @Override
    public Map<String, List<Match>> analyze(Stream<Path> roots, BannedImportGroup group) {
        return roots.flatMap(root -> this.ioUtil.listFiles((Path)root, this::isJavaSourceFile)).flatMap(path -> this.matcher.matchFile((Path)path, group)).collect(Collectors.groupingBy(Match::getSourceFile));
    }

    private boolean isJavaSourceFile(Path path) {
        return this.ioUtil.isFile(path) && path.getFileName().toString().toLowerCase().endsWith(".java");
    }

    @Override
    public void checkGroupConsistency(BannedImportGroup group) throws EnforcerRuleException {
        this.checkBannedImportsPresent(group);
        this.allowedImportMustMatchBasePattern(group);
    }

    private void checkBannedImportsPresent(BannedImportGroup group) throws EnforcerRuleException {
        if (group.getBannedImports().isEmpty()) {
            throw new EnforcerRuleException("There are no banned imports specified");
        }
    }

    private void allowedImportMustMatchBasePattern(BannedImportGroup group) throws EnforcerRuleException {
        for (PackagePattern allowedImport : group.getAllowedImports()) {
            boolean matches = group.getBasePackages().stream().anyMatch(basePackage -> basePackage.matches(allowedImport));
            if (matches) continue;
            throw new EnforcerRuleException(String.format("The allowed import pattern '%s' does not match any base package.", allowedImport));
        }
    }
}

