/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.impl;

import de.skuzzle.enforcer.restrictimports.model.PackagePattern;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PackagePatternImpl
implements PackagePattern {
    private final String[] parts;

    public PackagePatternImpl(String s) {
        this.parts = s.split("\\.");
        this.checkParts(s, this.parts);
    }

    private void checkParts(String full, String[] parts) {
        if (full.startsWith(".") || full.endsWith(".")) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains an empty part", full));
        }
        for (String part : parts) {
            if (part.isEmpty()) {
                throw new IllegalArgumentException(String.format("The pattern '%s' contains an empty part", full));
            }
            if ("*".equals(part) || "**".equals(part) || !part.contains("*")) continue;
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a part which mixes wildcards and normal characters", full));
        }
    }

    @Override
    public boolean matches(PackagePattern packagePattern) {
        if (packagePattern == this) {
            return true;
        }
        if (packagePattern instanceof PackagePatternImpl) {
            PackagePatternImpl ppi = (PackagePatternImpl)packagePattern;
            return this.matchesInternal(ppi.parts, this.parts);
        }
        return this.matches(packagePattern.toString());
    }

    @Override
    public boolean matches(String packageName) {
        String[] matchParts = packageName.split("\\.");
        return this.matchesInternal(matchParts, this.parts);
    }

    private boolean matchesInternal(String[] matchParts, String[] parts) {
        int patternIndex;
        if (parts.length > matchParts.length) {
            return false;
        }
        int matchIndex = 0;
        for (patternIndex = 0; patternIndex < parts.length && matchIndex < matchParts.length; ++patternIndex) {
            String patternPart = this.parts[patternIndex];
            String matchPart = matchParts[matchIndex];
            if ("**".equals(patternPart)) {
                if (patternIndex + 1 < parts.length) {
                    String nextPatternPart = parts[patternIndex + 1];
                    while (matchIndex < matchParts.length && !PackagePatternImpl.matchParts(nextPatternPart, matchParts[matchIndex])) {
                        ++matchIndex;
                    }
                    continue;
                }
                matchIndex = matchParts.length;
                continue;
            }
            if (PackagePatternImpl.matchParts(patternPart, matchPart)) {
                ++matchIndex;
                continue;
            }
            return false;
        }
        return patternIndex == parts.length && matchIndex == matchParts.length;
    }

    private static boolean matchParts(String patternPart, String matchPart) {
        if ("*".equals(patternPart) || "**".equals(patternPart)) {
            return true;
        }
        return patternPart.equals(matchPart);
    }

    public String toString() {
        return Arrays.stream(this.parts).collect(Collectors.joining("."));
    }

    public int hashCode() {
        return Arrays.hashCode(this.parts);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PackagePatternImpl && Arrays.equals(this.parts, ((PackagePatternImpl)obj).parts);
    }
}

