/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.samaxes.maven.minify.common.ClosureConfig;
import com.samaxes.maven.minify.common.JavaScriptErrorReporter;
import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.MinifyMojo;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;

public class ProcessJSFilesTask
extends ProcessFilesTask {
    private final ClosureConfig closureConfig;

    public ProcessJSFilesTask(Log log, boolean verbose, Integer bufferSize, Charset charset, String suffix, boolean nosuffix, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, MinifyMojo.Engine engine, YuiConfig yuiConfig, ClosureConfig closureConfig) throws FileNotFoundException {
        super(log, verbose, bufferSize, charset, suffix, nosuffix, skipMerge, skipMinify, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, engine, yuiConfig);
        this.closureConfig = closureConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        if (!minifiedFile.getParentFile().exists() && !minifiedFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Unable to create target directory for: " + minifiedFile.getParentFile());
        }
        try {
            in = new FileInputStream(mergedFile);
            var4_5 = null;
            try {
                out = new FileOutputStream(minifiedFile);
                var6_9 = null;
                try {
                    reader = new InputStreamReader((InputStream)in, this.charset);
                    var8_13 = null;
                    try {
                        writer = new OutputStreamWriter((OutputStream)out, this.charset);
                        var10_17 = null;
                        try {
                            this.log.info((CharSequence)("Creating the minified file [" + (this.verbose != false ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
                            switch (1.$SwitchMap$com$samaxes$maven$minify$plugin$MinifyMojo$Engine[this.engine.ordinal()]) {
                                case 1: {
                                    this.log.debug((CharSequence)"Using Google Closure Compiler engine.");
                                    options = new CompilerOptions();
                                    this.closureConfig.getCompilationLevel().setOptionsForCompilationLevel(options);
                                    options.setOutputCharset(this.charset);
                                    options.setLanguageIn(this.closureConfig.getLanguageIn());
                                    options.setLanguageOut(this.closureConfig.getLanguageOut());
                                    options.setDependencyOptions(this.closureConfig.getDependencyOptions());
                                    options.setColorizeErrorOutput(this.closureConfig.getColorizeErrorOutput().booleanValue());
                                    options.setAngularPass(this.closureConfig.getAngularPass().booleanValue());
                                    options.setExtraAnnotationNames(this.closureConfig.getExtraAnnotations());
                                    options.setDefineReplacements(this.closureConfig.getDefineReplacements());
                                    sourceMapResult = new File(minifiedFile.getPath() + ".map");
                                    if (this.closureConfig.getSourceMapFormat() != null) {
                                        options.setSourceMapFormat(this.closureConfig.getSourceMapFormat());
                                        options.setSourceMapOutputPath(sourceMapResult.getPath());
                                    }
                                    if (this.closureConfig.getWarningLevels() != null) {
                                        for (Map.Entry<DiagnosticGroup, CheckLevel> warningLevel : this.closureConfig.getWarningLevels().entrySet()) {
                                            options.setWarningLevel(warningLevel.getKey(), warningLevel.getValue());
                                        }
                                    }
                                    input = SourceFile.fromInputStream((String)mergedFile.getName(), (InputStream)in, (Charset)this.charset);
                                    externs = new ArrayList<SourceFile>();
                                    externs.addAll(CommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)this.closureConfig.getEnvironment()));
                                    externs.addAll(this.closureConfig.getExterns());
                                    compiler = new Compiler();
                                    compiler.compile(externs, (List)Lists.newArrayList((Object[])new SourceFile[]{input}), options);
                                    errors = compiler.getErrors();
                                    if (errors.length > 0) {
                                        msg = new StringBuilder("JSCompiler errors\n");
                                        formatter = new LightweightMessageFormatter((SourceExcerptProvider)compiler);
                                        for (JSError e : errors) {
                                            msg.append(formatter.formatError(e));
                                        }
                                        throw new RuntimeException(msg.toString());
                                    }
                                    writer.append(compiler.toSource());
                                    if (this.closureConfig.getSourceMapFormat() != null) {
                                        this.log.info((CharSequence)("Creating the minified file map [" + (this.verbose != false ? sourceMapResult.getPath() : sourceMapResult.getName()) + "]."));
                                        if (sourceMapResult.createNewFile()) {
                                            this.flushSourceMap(sourceMapResult, minifiedFile.getName(), compiler.getSourceMap());
                                            writer.append(System.getProperty("line.separator"));
                                            writer.append("//# sourceMappingURL=").append(sourceMapResult.getName());
                                            ** break;
                                        }
                                    }
lbl67:
                                    // 5 sources

                                    break;
                                }
                                case 2: {
                                    this.log.debug((CharSequence)"Using YUI Compressor engine.");
                                    compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.log, mergedFile.getName()));
                                    compressor.compress((Writer)writer, this.yuiConfig.getLineBreak(), this.yuiConfig.isMunge(), this.verbose, this.yuiConfig.isPreserveSemicolons(), this.yuiConfig.isDisableOptimizations());
                                    ** break;
lbl73:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    this.log.warn((CharSequence)"JavaScript engine not supported.");
                                    break;
                                }
                            }
                        }
                        catch (Throwable var11_20) {
                            var10_17 = var11_20;
                            throw var11_20;
                        }
                        finally {
                            if (writer != null) {
                                if (var10_17 != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable var11_19) {
                                        var10_17.addSuppressed(var11_19);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var9_16) {
                        var8_13 = var9_16;
                        throw var9_16;
                    }
                    finally {
                        if (reader != null) {
                            if (var8_13 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable var9_15) {
                                    var8_13.addSuppressed(var9_15);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (Throwable var7_12) {
                    var6_9 = var7_12;
                    throw var7_12;
                }
                finally {
                    if (out != null) {
                        if (var6_9 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable var7_11) {
                                var6_9.addSuppressed(var7_11);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Throwable var5_8) {
                var4_5 = var5_8;
                throw var5_8;
            }
            finally {
                if (in != null) {
                    if (var4_5 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable var5_7) {
                            var4_5.addSuppressed(var5_7);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Failed to compress the JavaScript file [" + (this.verbose != false ? mergedFile.getPath() : mergedFile.getName()) + "]."), (Throwable)e);
            throw e;
        }
        this.logCompressionGains(mergedFile, minifiedFile);
    }

    private void flushSourceMap(File sourceMapOutputFile, String minifyFileName, SourceMap sourceMap) {
        try (FileWriter out = new FileWriter(sourceMapOutputFile);){
            sourceMap.appendTo((Appendable)out, minifyFileName);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Failed to write the JavaScript Source Map file [" + (this.verbose ? sourceMapOutputFile.getPath() : sourceMapOutputFile.getName()) + "]."), (Throwable)e);
        }
    }
}

