/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.AutoZone;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionReqInfo;
import com.qiniu.storage.UpHostHelper;
import com.qiniu.util.StringUtils;

class ConfigHelper {
    private Configuration config;
    private UpHostHelper helper;

    ConfigHelper(Configuration config) {
        this.config = config;
        this.makeSureRegion();
    }

    public String upHost(String upToken) throws QiniuException {
        try {
            return this.upHost(upToken, null, false, false);
        }
        catch (QiniuException e) {
            if (e.response == null || e.response.needRetry()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.upHost(upToken, null, false, true);
            }
            throw e;
        }
    }

    public String tryChangeUpHost(String upToken, String lastUsedHost) throws QiniuException {
        return this.upHost(upToken, lastUsedHost, true, false);
    }

    private String upHost(String upToken, String lastUsedHost, boolean changeHost, boolean mustReturnUpHost) throws QiniuException {
        return this.getScheme() + this.getHelper().upHost(this.config.region, upToken, this.toDomain(lastUsedHost), changeHost, mustReturnUpHost);
    }

    public String ioHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getIovipHost(regionReqInfo);
    }

    public String apiHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getApiHost(regionReqInfo);
    }

    public String rsHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getRsHost(regionReqInfo);
    }

    public String rsfHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getRsfHost(regionReqInfo);
    }

    public String rsHost() {
        return this.getScheme() + Configuration.defaultRsHost;
    }

    public String apiHost() {
        return this.getScheme() + Configuration.defaultApiHost;
    }

    public String ucHost() {
        return this.getScheme() + Configuration.defaultUcHost;
    }

    private String getScheme() {
        return this.config.useHttpsDomains ? "https://" : "http://";
    }

    private void makeSureRegion() {
        if (this.config.region == null) {
            this.config.region = this.config.zone != null ? this.toRegion(this.config.zone) : Region.autoRegion();
        }
    }

    private UpHostHelper getHelper() {
        if (this.helper == null) {
            this.helper = new UpHostHelper(this.config, 900);
        }
        return this.helper;
    }

    private Region toRegion(Zone zone) {
        if (zone instanceof AutoZone) {
            AutoZone autoZone = (AutoZone)zone;
            return Region.autoRegion(autoZone.ucServer);
        }
        return new Region.Builder().region(zone.getRegion()).accUpHost(this.getHosts(zone.getUpHttps(null), zone.getUpHttp(null))).srcUpHost(this.getHosts(zone.getUpBackupHttps(null), zone.getUpBackupHttp(null))).iovipHost(this.getHost(zone.getIovipHttps(null), zone.getIovipHttp(null))).rsHost(this.getHost(zone.getRsHttps(), zone.getRsHttp())).rsfHost(this.getHost(zone.getRsfHttps(), zone.getRsfHttp())).apiHost(this.getHost(zone.getApiHttps(), zone.getApiHttp())).build();
    }

    private String getHost(String https, String http) {
        if (this.config.useHttpsDomains) {
            return this.toDomain(https);
        }
        return this.toDomain(http);
    }

    private String[] getHosts(String https, String http) {
        if (this.config.useHttpsDomains) {
            return new String[]{this.toDomain(https)};
        }
        String s1 = this.toDomain(http);
        String s2 = this.toDomain(https);
        if (s2 != null && !s2.equalsIgnoreCase(s1)) {
            return new String[]{s1, s2};
        }
        return new String[]{s1};
    }

    private String toDomain(String d1) {
        if (StringUtils.isNullOrEmpty(d1)) {
            return null;
        }
        int s = d1.indexOf("://");
        if (s > -1) {
            return d1.substring(s + 3);
        }
        return d1;
    }
}

