/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Region;
import com.qiniu.common.RegionReqInfo;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AutoRegion
extends Region {
    private final String ucServer;
    private Map<RegionIndex, RegionInfo> regions;
    private Map<String, Region> inferDomainsMap;
    private Client client;

    public AutoRegion() {
        this("https://uc.qbox.me");
    }

    public AutoRegion(String ucServer) {
        this.ucServer = ucServer;
        this.client = new Client();
        this.regions = new ConcurrentHashMap<RegionIndex, RegionInfo>();
        this.inferDomainsMap = new ConcurrentHashMap<String, Region>();
        this.inferDomainsMap.put("up.qiniup.com", AutoRegion.region0());
        this.inferDomainsMap.put("up-jjh.qiniup.com", AutoRegion.region0());
        this.inferDomainsMap.put("up-xs.qiniup.com", AutoRegion.region0());
        this.inferDomainsMap.put("up-z1.qiniup.com", AutoRegion.region1());
        this.inferDomainsMap.put("up-z2.qiniup.com", AutoRegion.region2());
        this.inferDomainsMap.put("up-dg.qiniup.com", AutoRegion.region2());
        this.inferDomainsMap.put("up-fs.qiniup.com", AutoRegion.region2());
        this.inferDomainsMap.put("up-na0.qiniup.com", AutoRegion.regionNa0());
        this.inferDomainsMap.put("up-as0.qiniup.com", AutoRegion.regionAs0());
    }

    private UCRet getRegionJson(RegionIndex index) throws QiniuException {
        String address = this.ucServer + "/v2/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Response r = this.client.get(address);
        return r.jsonToObject(UCRet.class);
    }

    public RegionInfo queryRegionInfo(String accessKey, String bucket) throws QiniuException {
        RegionIndex index = new RegionIndex(accessKey, bucket);
        RegionInfo info = this.regions.get(index);
        if (info == null) {
            UCRet ret = this.getRegionJson(index);
            try {
                info = RegionInfo.buildFromUcRet(ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (info != null) {
                this.regions.put(index, info);
            }
        }
        return info;
    }

    public RegionInfo queryRegionInfo(RegionReqInfo regionReqInfo) {
        try {
            return this.queryRegionInfo(regionReqInfo.getAccessKey(), regionReqInfo.getBucket());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSrcUpHost(RegionReqInfo regionReqInfo) {
        RegionInfo info = this.queryRegionInfo(regionReqInfo);
        if (info == null) {
            return "";
        }
        return info.srcUpHosts.get(0);
    }

    @Override
    public String getAccUpHost(RegionReqInfo regionReqInfo) {
        RegionInfo info = this.queryRegionInfo(regionReqInfo);
        if (info == null) {
            return "";
        }
        return info.accUpHosts.get(0);
    }

    @Override
    public String getIovipHost(RegionReqInfo regionReqInfo) {
        RegionInfo info = this.queryRegionInfo(regionReqInfo);
        if (info == null) {
            return "";
        }
        return info.iovipHost;
    }

    @Override
    public String getRsHost(RegionReqInfo regionReqInfo) {
        RegionInfo info = this.queryRegionInfo(regionReqInfo);
        if (info == null) {
            return super.getRsHost(regionReqInfo);
        }
        Region region = this.inferDomainsMap.get(info.srcUpHosts.get(0));
        if (region != null) {
            return region.getRsHost(regionReqInfo);
        }
        return super.getRsHost(regionReqInfo);
    }

    @Override
    public String getRsfHost(RegionReqInfo regionReqInfo) {
        RegionInfo info = this.queryRegionInfo(regionReqInfo);
        if (info == null) {
            return super.getRsfHost(regionReqInfo);
        }
        Region region = this.inferDomainsMap.get(info.srcUpHosts.get(0));
        if (region != null) {
            return region.getRsfHost(regionReqInfo);
        }
        return super.getRsfHost(regionReqInfo);
    }

    @Override
    public String getApiHost(RegionReqInfo regionReqInfo) {
        RegionInfo info = this.queryRegionInfo(regionReqInfo);
        if (info == null) {
            return super.getApiHost(regionReqInfo);
        }
        Region region = this.inferDomainsMap.get(info.srcUpHosts.get(0));
        if (region != null) {
            return region.getApiHost(regionReqInfo);
        }
        return super.getApiHost(regionReqInfo);
    }

    private class IORet {
        Map<String, List<String>> src;

        private IORet() {
        }
    }

    private class UPRet {
        Map<String, List<String>> acc;
        Map<String, List<String>> src;

        private UPRet() {
        }
    }

    private class UCRet {
        UPRet up;
        IORet io;

        private UCRet() {
        }
    }

    private static class RegionIndex {
        private final String accessKey;
        private final String bucket;

        RegionIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof RegionIndex && ((RegionIndex)obj).accessKey.equals(this.accessKey) && ((RegionIndex)obj).bucket.equals(this.bucket);
        }
    }

    static class RegionInfo {
        final List<String> srcUpHosts;
        final List<String> accUpHosts;
        final String iovipHost;

        protected RegionInfo(List<String> srcUpHosts, List<String> accUpHosts, String iovipHost) {
            this.srcUpHosts = srcUpHosts;
            this.accUpHosts = accUpHosts;
            this.iovipHost = iovipHost;
        }

        static RegionInfo buildFromUcRet(UCRet ret) {
            ArrayList<String> srcUpHosts = new ArrayList<String>();
            RegionInfo.addAll(srcUpHosts, ret.up.src.get("main"));
            RegionInfo.addAll(srcUpHosts, ret.up.src.get("backup"));
            ArrayList<String> accUpHosts = new ArrayList<String>();
            RegionInfo.addAll(accUpHosts, ret.up.acc.get("main"));
            RegionInfo.addAll(accUpHosts, ret.up.acc.get("backup"));
            String iovipHost = ret.io.src.get("main").get(0);
            return new RegionInfo(srcUpHosts, accUpHosts, iovipHost);
        }

        static void addAll(List<String> s, List<String> p) {
            if (p != null) {
                s.addAll(p);
            }
        }
    }
}

