/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.common.ZoneReqInfo;
import com.qiniu.http.Dns;
import com.qiniu.http.ProxyConfiguration;

public final class Configuration
implements Cloneable {
    public Zone zone;
    public boolean useHttpsDomains = false;
    public int putThreshold = 0x400000;
    public int connectTimeout = 10;
    public int writeTimeout = 0;
    public int readTimeout = 30;
    public int dispatcherMaxRequests = 64;
    public int dispatcherMaxRequestsPerHost = 16;
    public int connectionPoolMaxIdleCount = 32;
    public int connectionPoolMaxIdleMinutes = 5;
    public int retryMax = 5;
    public Dns dns;
    public boolean useDnsHostFirst;
    public ProxyConfiguration proxy;
    public static String defaultRsHost = "rs.qiniu.com";
    public static String defaultApiHost = "api.qiniu.com";

    public Configuration() {
    }

    public Configuration(Zone zone) {
        this.zone = zone;
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String upHost(String upToken) throws QiniuException {
        ZoneReqInfo zoneReqInfo = new ZoneReqInfo(upToken);
        if (this.zone == null) {
            this.zone = Zone.autoZone();
        }
        return this.useHttpsDomains ? this.zone.getUpHttps(zoneReqInfo) : this.zone.getUpHttp(zoneReqInfo);
    }

    public String upHostBackup(String upToken) throws QiniuException {
        ZoneReqInfo zoneReqInfo = new ZoneReqInfo(upToken);
        if (this.zone == null) {
            this.zone = Zone.autoZone();
        }
        return this.useHttpsDomains ? this.zone.getUpBackupHttps(zoneReqInfo) : this.zone.getUpBackupHttp(zoneReqInfo);
    }

    public String ioHost(String ak, String bucket) {
        ZoneReqInfo zoneReqInfo = new ZoneReqInfo(ak, bucket);
        if (this.zone == null) {
            this.zone = Zone.autoZone();
        }
        return this.useHttpsDomains ? this.zone.getIovipHttps(zoneReqInfo) : this.zone.getIovipHttp(zoneReqInfo);
    }

    public String apiHost(String ak, String bucket) {
        ZoneReqInfo zoneReqInfo = new ZoneReqInfo(ak, bucket);
        if (this.zone == null) {
            this.zone = Zone.autoZone();
        }
        return this.useHttpsDomains ? this.zone.getApiHttps(zoneReqInfo) : this.zone.getApiHttp(zoneReqInfo);
    }

    public String rsHost() {
        String scheme = "http://";
        if (this.useHttpsDomains) {
            scheme = "https://";
        }
        return scheme + defaultRsHost;
    }

    public String apiHost() {
        String scheme = "http://";
        if (this.useHttpsDomains) {
            scheme = "https://";
        }
        return scheme + defaultApiHost;
    }

    public String rsHost(String ak, String bucket) {
        ZoneReqInfo zoneReqInfo = new ZoneReqInfo(ak, bucket);
        if (this.zone == null) {
            this.zone = Zone.autoZone();
        }
        return this.useHttpsDomains ? this.zone.getRsHttps(zoneReqInfo) : this.zone.getRsHttp(zoneReqInfo);
    }

    public String rsfHost(String ak, String bucket) {
        ZoneReqInfo zoneReqInfo = new ZoneReqInfo(ak, bucket);
        if (this.zone == null) {
            this.zone = Zone.autoZone();
        }
        return this.useHttpsDomains ? this.zone.getRsfHttps(zoneReqInfo) : this.zone.getRsfHttp(zoneReqInfo);
    }
}

