/*
 * Decompiled with CFR 0.152.
 */
package com.pdfcrowd;

import com.pdfcrowd.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class Pdfcrowd {
    private static final String HOST = System.getenv("PDFCROWD_HOST") != null ? System.getenv("PDFCROWD_HOST") : "api.pdfcrowd.com";
    private static final String MULTIPART_BOUNDARY = "----------ThIs_Is_tHe_bOUnDary_$";
    public static final String CLIENT_VERSION = "4.11.0";

    static String createInvalidValueMessage(Object value, String field, String converter, String hint, String id) {
        String message = String.format("Invalid value '%s' for a field '%s'.", value, field);
        if (hint != null) {
            message = message + " " + hint;
        }
        return message + " " + String.format("Details: https://www.pdfcrowd.com/doc/api/%s/java/#%s", converter, id);
    }

    public static final class ImageToPdfClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public ImageToPdfClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "image");
            this.fields.put("output_format", "pdf");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "image-to-pdf", "The supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "image-to-pdf", "The supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "image-to-pdf", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "image-to-pdf", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "image-to-pdf", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "image-to-pdf", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "image-to-pdf", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public ImageToPdfClient setResize(String resize) {
            this.fields.put("resize", resize);
            return this;
        }

        public ImageToPdfClient setRotate(String rotate) {
            this.fields.put("rotate", rotate);
            return this;
        }

        public ImageToPdfClient setDebugLog(boolean debugLog) {
            this.fields.put("debug_log", debugLog ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public ImageToPdfClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public ImageToPdfClient setHttpProxy(String httpProxy) {
            if (!httpProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpProxy, "http_proxy", "image-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", httpProxy);
            return this;
        }

        public ImageToPdfClient setHttpsProxy(String httpsProxy) {
            if (!httpsProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpsProxy, "https_proxy", "image-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", httpsProxy);
            return this;
        }

        public ImageToPdfClient setUseHttp(boolean useHttp) {
            this.helper.setUseHttp(useHttp);
            return this;
        }

        public ImageToPdfClient setUserAgent(String userAgent) {
            this.helper.setUserAgent(userAgent);
            return this;
        }

        public ImageToPdfClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public ImageToPdfClient setRetryCount(int retryCount) {
            this.helper.setRetryCount(retryCount);
            return this;
        }
    }

    public static final class PdfToPdfClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public PdfToPdfClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "pdf");
            this.fields.put("output_format", "pdf");
        }

        public PdfToPdfClient setAction(String action) {
            if (!action.matches("(?i)^(join|shuffle)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(action, "action", "pdf-to-pdf", "Allowed values are join, shuffle.", "set_action"), 470);
            }
            this.fields.put("action", action);
            return this;
        }

        public byte[] convert() {
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertToStream(OutputStream outStream) {
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertToFile(String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "pdf-to-pdf", "The string must not be empty.", "convert_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            this.convertToStream(outputFile);
            outputFile.close();
        }

        public PdfToPdfClient addPdfFile(String filePath) {
            if (new File(filePath).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "pdf-to-pdf", "The file must exist and not be empty.", "add_pdf_file"), 470);
            }
            this.files.put("f_" + Integer.toString(this.fileId), filePath);
            ++this.fileId;
            return this;
        }

        public PdfToPdfClient addPdfRawData(byte[] pdfRawData) {
            if (pdfRawData == null || pdfRawData.length <= 300 || !new String(pdfRawData, 0, 4).equals("%PDF")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage("raw PDF data", "pdf_raw_data", "pdf-to-pdf", "The input data must be PDF content.", "add_pdf_raw_data"), 470);
            }
            this.rawData.put("f_" + Integer.toString(this.fileId), pdfRawData);
            ++this.fileId;
            return this;
        }

        public PdfToPdfClient setPageWatermark(String pageWatermark) {
            if (new File(pageWatermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageWatermark, "page_watermark", "pdf-to-pdf", "The file must exist and not be empty.", "set_page_watermark"), 470);
            }
            this.files.put("page_watermark", pageWatermark);
            return this;
        }

        public PdfToPdfClient setPageWatermarkUrl(String pageWatermarkUrl) {
            if (!pageWatermarkUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageWatermarkUrl, "page_watermark_url", "pdf-to-pdf", "The supported protocols are http:// and https://.", "set_page_watermark_url"), 470);
            }
            this.fields.put("page_watermark_url", pageWatermarkUrl);
            return this;
        }

        public PdfToPdfClient setMultipageWatermark(String multipageWatermark) {
            if (new File(multipageWatermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageWatermark, "multipage_watermark", "pdf-to-pdf", "The file must exist and not be empty.", "set_multipage_watermark"), 470);
            }
            this.files.put("multipage_watermark", multipageWatermark);
            return this;
        }

        public PdfToPdfClient setMultipageWatermarkUrl(String multipageWatermarkUrl) {
            if (!multipageWatermarkUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageWatermarkUrl, "multipage_watermark_url", "pdf-to-pdf", "The supported protocols are http:// and https://.", "set_multipage_watermark_url"), 470);
            }
            this.fields.put("multipage_watermark_url", multipageWatermarkUrl);
            return this;
        }

        public PdfToPdfClient setPageBackground(String pageBackground) {
            if (new File(pageBackground).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageBackground, "page_background", "pdf-to-pdf", "The file must exist and not be empty.", "set_page_background"), 470);
            }
            this.files.put("page_background", pageBackground);
            return this;
        }

        public PdfToPdfClient setPageBackgroundUrl(String pageBackgroundUrl) {
            if (!pageBackgroundUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageBackgroundUrl, "page_background_url", "pdf-to-pdf", "The supported protocols are http:// and https://.", "set_page_background_url"), 470);
            }
            this.fields.put("page_background_url", pageBackgroundUrl);
            return this;
        }

        public PdfToPdfClient setMultipageBackground(String multipageBackground) {
            if (new File(multipageBackground).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageBackground, "multipage_background", "pdf-to-pdf", "The file must exist and not be empty.", "set_multipage_background"), 470);
            }
            this.files.put("multipage_background", multipageBackground);
            return this;
        }

        public PdfToPdfClient setMultipageBackgroundUrl(String multipageBackgroundUrl) {
            if (!multipageBackgroundUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageBackgroundUrl, "multipage_background_url", "pdf-to-pdf", "The supported protocols are http:// and https://.", "set_multipage_background_url"), 470);
            }
            this.fields.put("multipage_background_url", multipageBackgroundUrl);
            return this;
        }

        public PdfToPdfClient setLinearize(boolean linearize) {
            this.fields.put("linearize", linearize ? "true" : null);
            return this;
        }

        public PdfToPdfClient setEncrypt(boolean encrypt) {
            this.fields.put("encrypt", encrypt ? "true" : null);
            return this;
        }

        public PdfToPdfClient setUserPassword(String userPassword) {
            this.fields.put("user_password", userPassword);
            return this;
        }

        public PdfToPdfClient setOwnerPassword(String ownerPassword) {
            this.fields.put("owner_password", ownerPassword);
            return this;
        }

        public PdfToPdfClient setNoPrint(boolean noPrint) {
            this.fields.put("no_print", noPrint ? "true" : null);
            return this;
        }

        public PdfToPdfClient setNoModify(boolean noModify) {
            this.fields.put("no_modify", noModify ? "true" : null);
            return this;
        }

        public PdfToPdfClient setNoCopy(boolean noCopy) {
            this.fields.put("no_copy", noCopy ? "true" : null);
            return this;
        }

        public PdfToPdfClient setPageLayout(String pageLayout) {
            if (!pageLayout.matches("(?i)^(single-page|one-column|two-column-left|two-column-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageLayout, "page_layout", "pdf-to-pdf", "Allowed values are single-page, one-column, two-column-left, two-column-right.", "set_page_layout"), 470);
            }
            this.fields.put("page_layout", pageLayout);
            return this;
        }

        public PdfToPdfClient setPageMode(String pageMode) {
            if (!pageMode.matches("(?i)^(full-screen|thumbnails|outlines)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageMode, "page_mode", "pdf-to-pdf", "Allowed values are full-screen, thumbnails, outlines.", "set_page_mode"), 470);
            }
            this.fields.put("page_mode", pageMode);
            return this;
        }

        public PdfToPdfClient setInitialZoomType(String initialZoomType) {
            if (!initialZoomType.matches("(?i)^(fit-width|fit-height|fit-page)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(initialZoomType, "initial_zoom_type", "pdf-to-pdf", "Allowed values are fit-width, fit-height, fit-page.", "set_initial_zoom_type"), 470);
            }
            this.fields.put("initial_zoom_type", initialZoomType);
            return this;
        }

        public PdfToPdfClient setInitialPage(int initialPage) {
            if (initialPage <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(initialPage, "initial_page", "pdf-to-pdf", "Must be a positive integer number.", "set_initial_page"), 470);
            }
            this.fields.put("initial_page", Integer.toString(initialPage));
            return this;
        }

        public PdfToPdfClient setInitialZoom(int initialZoom) {
            if (initialZoom <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(initialZoom, "initial_zoom", "pdf-to-pdf", "Must be a positive integer number.", "set_initial_zoom"), 470);
            }
            this.fields.put("initial_zoom", Integer.toString(initialZoom));
            return this;
        }

        public PdfToPdfClient setHideToolbar(boolean hideToolbar) {
            this.fields.put("hide_toolbar", hideToolbar ? "true" : null);
            return this;
        }

        public PdfToPdfClient setHideMenubar(boolean hideMenubar) {
            this.fields.put("hide_menubar", hideMenubar ? "true" : null);
            return this;
        }

        public PdfToPdfClient setHideWindowUi(boolean hideWindowUi) {
            this.fields.put("hide_window_ui", hideWindowUi ? "true" : null);
            return this;
        }

        public PdfToPdfClient setFitWindow(boolean fitWindow) {
            this.fields.put("fit_window", fitWindow ? "true" : null);
            return this;
        }

        public PdfToPdfClient setCenterWindow(boolean centerWindow) {
            this.fields.put("center_window", centerWindow ? "true" : null);
            return this;
        }

        public PdfToPdfClient setDisplayTitle(boolean displayTitle) {
            this.fields.put("display_title", displayTitle ? "true" : null);
            return this;
        }

        public PdfToPdfClient setRightToLeft(boolean rightToLeft) {
            this.fields.put("right_to_left", rightToLeft ? "true" : null);
            return this;
        }

        public PdfToPdfClient setDebugLog(boolean debugLog) {
            this.fields.put("debug_log", debugLog ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public PdfToPdfClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public PdfToPdfClient setUseHttp(boolean useHttp) {
            this.helper.setUseHttp(useHttp);
            return this;
        }

        public PdfToPdfClient setUserAgent(String userAgent) {
            this.helper.setUserAgent(userAgent);
            return this;
        }

        public PdfToPdfClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public PdfToPdfClient setRetryCount(int retryCount) {
            this.helper.setRetryCount(retryCount);
            return this;
        }
    }

    public static final class ImageToImageClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public ImageToImageClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "image");
            this.fields.put("output_format", "png");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "image-to-image", "The supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "image-to-image", "The supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "image-to-image", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "image-to-image", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "image-to-image", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "image-to-image", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "image-to-image", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public ImageToImageClient setOutputFormat(String outputFormat) {
            if (!outputFormat.matches("(?i)^(png|jpg|gif|tiff|bmp|ico|ppm|pgm|pbm|pnm|psb|pct|ras|tga|sgi|sun|webp)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(outputFormat, "output_format", "image-to-image", "Allowed values are png, jpg, gif, tiff, bmp, ico, ppm, pgm, pbm, pnm, psb, pct, ras, tga, sgi, sun, webp.", "set_output_format"), 470);
            }
            this.fields.put("output_format", outputFormat);
            return this;
        }

        public ImageToImageClient setResize(String resize) {
            this.fields.put("resize", resize);
            return this;
        }

        public ImageToImageClient setRotate(String rotate) {
            this.fields.put("rotate", rotate);
            return this;
        }

        public ImageToImageClient setDebugLog(boolean debugLog) {
            this.fields.put("debug_log", debugLog ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public ImageToImageClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public ImageToImageClient setHttpProxy(String httpProxy) {
            if (!httpProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpProxy, "http_proxy", "image-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", httpProxy);
            return this;
        }

        public ImageToImageClient setHttpsProxy(String httpsProxy) {
            if (!httpsProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpsProxy, "https_proxy", "image-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", httpsProxy);
            return this;
        }

        public ImageToImageClient setUseHttp(boolean useHttp) {
            this.helper.setUseHttp(useHttp);
            return this;
        }

        public ImageToImageClient setUserAgent(String userAgent) {
            this.helper.setUserAgent(userAgent);
            return this;
        }

        public ImageToImageClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public ImageToImageClient setRetryCount(int retryCount) {
            this.helper.setRetryCount(retryCount);
            return this;
        }
    }

    public static final class HtmlToImageClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public HtmlToImageClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "html");
            this.fields.put("output_format", "png");
        }

        public HtmlToImageClient setOutputFormat(String outputFormat) {
            if (!outputFormat.matches("(?i)^(png|jpg|gif|tiff|bmp|ico|ppm|pgm|pbm|pnm|psb|pct|ras|tga|sgi|sun|webp)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(outputFormat, "output_format", "html-to-image", "Allowed values are png, jpg, gif, tiff, bmp, ico, ppm, pgm, pbm, pnm, psb, pct, ras, tga, sgi, sun, webp.", "set_output_format"), 470);
            }
            this.fields.put("output_format", outputFormat);
            return this;
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "html-to-image", "The supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "html-to-image", "The supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "html-to-image", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "html-to-image", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "html-to-image", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "html-to-image", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertString(String text) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "text", "html-to-image", "The string must not be empty.", "convert_string"), 470);
            }
            this.fields.put("text", text);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStringToStream(String text, OutputStream outStream) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "text", "html-to-image", "The string must not be empty.", "convert_string_to_stream"), 470);
            }
            this.fields.put("text", text);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStringToFile(String text, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "html-to-image", "The string must not be empty.", "convert_string_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStringToStream(text, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public HtmlToImageClient setNoBackground(boolean noBackground) {
            this.fields.put("no_background", noBackground ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDisableJavascript(boolean disableJavascript) {
            this.fields.put("disable_javascript", disableJavascript ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDisableImageLoading(boolean disableImageLoading) {
            this.fields.put("disable_image_loading", disableImageLoading ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDisableRemoteFonts(boolean disableRemoteFonts) {
            this.fields.put("disable_remote_fonts", disableRemoteFonts ? "true" : null);
            return this;
        }

        public HtmlToImageClient setBlockAds(boolean blockAds) {
            this.fields.put("block_ads", blockAds ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDefaultEncoding(String defaultEncoding) {
            this.fields.put("default_encoding", defaultEncoding);
            return this;
        }

        public HtmlToImageClient setHttpAuthUserName(String userName) {
            this.fields.put("http_auth_user_name", userName);
            return this;
        }

        public HtmlToImageClient setHttpAuthPassword(String password) {
            this.fields.put("http_auth_password", password);
            return this;
        }

        public HtmlToImageClient setHttpAuth(String userName, String password) {
            this.setHttpAuthUserName(userName);
            this.setHttpAuthPassword(password);
            return this;
        }

        public HtmlToImageClient setUsePrintMedia(boolean usePrintMedia) {
            this.fields.put("use_print_media", usePrintMedia ? "true" : null);
            return this;
        }

        public HtmlToImageClient setNoXpdfcrowdHeader(boolean noXpdfcrowdHeader) {
            this.fields.put("no_xpdfcrowd_header", noXpdfcrowdHeader ? "true" : null);
            return this;
        }

        public HtmlToImageClient setCookies(String cookies) {
            this.fields.put("cookies", cookies);
            return this;
        }

        public HtmlToImageClient setVerifySslCertificates(boolean verifySslCertificates) {
            this.fields.put("verify_ssl_certificates", verifySslCertificates ? "true" : null);
            return this;
        }

        public HtmlToImageClient setFailOnMainUrlError(boolean failOnError) {
            this.fields.put("fail_on_main_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToImageClient setFailOnAnyUrlError(boolean failOnError) {
            this.fields.put("fail_on_any_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToImageClient setCustomJavascript(String customJavascript) {
            if (customJavascript == null || customJavascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(customJavascript, "custom_javascript", "html-to-image", "The string must not be empty.", "set_custom_javascript"), 470);
            }
            this.fields.put("custom_javascript", customJavascript);
            return this;
        }

        public HtmlToImageClient setOnLoadJavascript(String onLoadJavascript) {
            if (onLoadJavascript == null || onLoadJavascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(onLoadJavascript, "on_load_javascript", "html-to-image", "The string must not be empty.", "set_on_load_javascript"), 470);
            }
            this.fields.put("on_load_javascript", onLoadJavascript);
            return this;
        }

        public HtmlToImageClient setCustomHttpHeader(String customHttpHeader) {
            if (!customHttpHeader.matches("^.+:.+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(customHttpHeader, "custom_http_header", "html-to-image", "A string containing the header name and value separated by a colon.", "set_custom_http_header"), 470);
            }
            this.fields.put("custom_http_header", customHttpHeader);
            return this;
        }

        public HtmlToImageClient setJavascriptDelay(int javascriptDelay) {
            if (javascriptDelay < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(javascriptDelay, "javascript_delay", "html-to-image", "Must be a positive integer number or 0.", "set_javascript_delay"), 470);
            }
            this.fields.put("javascript_delay", Integer.toString(javascriptDelay));
            return this;
        }

        public HtmlToImageClient setElementToConvert(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "selectors", "html-to-image", "The string must not be empty.", "set_element_to_convert"), 470);
            }
            this.fields.put("element_to_convert", selectors);
            return this;
        }

        public HtmlToImageClient setElementToConvertMode(String mode) {
            if (!mode.matches("(?i)^(cut-out|remove-siblings|hide-siblings)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "mode", "html-to-image", "Allowed values are cut-out, remove-siblings, hide-siblings.", "set_element_to_convert_mode"), 470);
            }
            this.fields.put("element_to_convert_mode", mode);
            return this;
        }

        public HtmlToImageClient setWaitForElement(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "selectors", "html-to-image", "The string must not be empty.", "set_wait_for_element"), 470);
            }
            this.fields.put("wait_for_element", selectors);
            return this;
        }

        public HtmlToImageClient setScreenshotWidth(int screenshotWidth) {
            if (screenshotWidth < 96 || screenshotWidth > 65000) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(screenshotWidth, "screenshot_width", "html-to-image", "The value must be in the range 96-65000.", "set_screenshot_width"), 470);
            }
            this.fields.put("screenshot_width", Integer.toString(screenshotWidth));
            return this;
        }

        public HtmlToImageClient setScreenshotHeight(int screenshotHeight) {
            if (screenshotHeight <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(screenshotHeight, "screenshot_height", "html-to-image", "Must be a positive integer number.", "set_screenshot_height"), 470);
            }
            this.fields.put("screenshot_height", Integer.toString(screenshotHeight));
            return this;
        }

        public HtmlToImageClient setScaleFactor(int scaleFactor) {
            if (scaleFactor <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(scaleFactor, "scale_factor", "html-to-image", "Must be a positive integer number.", "set_scale_factor"), 470);
            }
            this.fields.put("scale_factor", Integer.toString(scaleFactor));
            return this;
        }

        public HtmlToImageClient setDebugLog(boolean debugLog) {
            this.fields.put("debug_log", debugLog ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public HtmlToImageClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public HtmlToImageClient setHttpProxy(String httpProxy) {
            if (!httpProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpProxy, "http_proxy", "html-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", httpProxy);
            return this;
        }

        public HtmlToImageClient setHttpsProxy(String httpsProxy) {
            if (!httpsProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpsProxy, "https_proxy", "html-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", httpsProxy);
            return this;
        }

        public HtmlToImageClient setClientCertificate(String clientCertificate) {
            if (new File(clientCertificate).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(clientCertificate, "client_certificate", "html-to-image", "The file must exist and not be empty.", "set_client_certificate"), 470);
            }
            this.files.put("client_certificate", clientCertificate);
            return this;
        }

        public HtmlToImageClient setClientCertificatePassword(String clientCertificatePassword) {
            this.fields.put("client_certificate_password", clientCertificatePassword);
            return this;
        }

        public HtmlToImageClient setUseHttp(boolean useHttp) {
            this.helper.setUseHttp(useHttp);
            return this;
        }

        public HtmlToImageClient setUserAgent(String userAgent) {
            this.helper.setUserAgent(userAgent);
            return this;
        }

        public HtmlToImageClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public HtmlToImageClient setRetryCount(int retryCount) {
            this.helper.setRetryCount(retryCount);
            return this;
        }
    }

    public static final class HtmlToPdfClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public HtmlToPdfClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "html");
            this.fields.put("output_format", "pdf");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "html-to-pdf", "The supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "url", "html-to-pdf", "The supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "html-to-pdf", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "html-to-pdf", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "file", "html-to-pdf", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "html-to-pdf", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertString(String text) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "text", "html-to-pdf", "The string must not be empty.", "convert_string"), 470);
            }
            this.fields.put("text", text);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStringToStream(String text, OutputStream outStream) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "text", "html-to-pdf", "The string must not be empty.", "convert_string_to_stream"), 470);
            }
            this.fields.put("text", text);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStringToFile(String text, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "file_path", "html-to-pdf", "The string must not be empty.", "convert_string_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStringToStream(text, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public HtmlToPdfClient setPageSize(String pageSize) {
            if (!pageSize.matches("(?i)^(A2|A3|A4|A5|A6|Letter)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageSize, "page_size", "html-to-pdf", "Allowed values are A2, A3, A4, A5, A6, Letter.", "set_page_size"), 470);
            }
            this.fields.put("page_size", pageSize);
            return this;
        }

        public HtmlToPdfClient setPageWidth(String pageWidth) {
            if (!pageWidth.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageWidth, "page_width", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_page_width"), 470);
            }
            this.fields.put("page_width", pageWidth);
            return this;
        }

        public HtmlToPdfClient setPageHeight(String pageHeight) {
            if (!pageHeight.matches("(?i)^\\-1$|^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageHeight, "page_height", "html-to-pdf", "Can be -1 or specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_page_height"), 470);
            }
            this.fields.put("page_height", pageHeight);
            return this;
        }

        public HtmlToPdfClient setPageDimensions(String width, String height) {
            this.setPageWidth(width);
            this.setPageHeight(height);
            return this;
        }

        public HtmlToPdfClient setOrientation(String orientation) {
            if (!orientation.matches("(?i)^(landscape|portrait)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(orientation, "orientation", "html-to-pdf", "Allowed values are landscape, portrait.", "set_orientation"), 470);
            }
            this.fields.put("orientation", orientation);
            return this;
        }

        public HtmlToPdfClient setMarginTop(String marginTop) {
            if (!marginTop.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(marginTop, "margin_top", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_margin_top"), 470);
            }
            this.fields.put("margin_top", marginTop);
            return this;
        }

        public HtmlToPdfClient setMarginRight(String marginRight) {
            if (!marginRight.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(marginRight, "margin_right", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_margin_right"), 470);
            }
            this.fields.put("margin_right", marginRight);
            return this;
        }

        public HtmlToPdfClient setMarginBottom(String marginBottom) {
            if (!marginBottom.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(marginBottom, "margin_bottom", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_margin_bottom"), 470);
            }
            this.fields.put("margin_bottom", marginBottom);
            return this;
        }

        public HtmlToPdfClient setMarginLeft(String marginLeft) {
            if (!marginLeft.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(marginLeft, "margin_left", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_margin_left"), 470);
            }
            this.fields.put("margin_left", marginLeft);
            return this;
        }

        public HtmlToPdfClient setNoMargins(boolean noMargins) {
            this.fields.put("no_margins", noMargins ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setPageMargins(String top, String right, String bottom, String left) {
            this.setMarginTop(top);
            this.setMarginRight(right);
            this.setMarginBottom(bottom);
            this.setMarginLeft(left);
            return this;
        }

        public HtmlToPdfClient setHeaderUrl(String headerUrl) {
            if (!headerUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(headerUrl, "header_url", "html-to-pdf", "The supported protocols are http:// and https://.", "set_header_url"), 470);
            }
            this.fields.put("header_url", headerUrl);
            return this;
        }

        public HtmlToPdfClient setHeaderHtml(String headerHtml) {
            if (headerHtml == null || headerHtml.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(headerHtml, "header_html", "html-to-pdf", "The string must not be empty.", "set_header_html"), 470);
            }
            this.fields.put("header_html", headerHtml);
            return this;
        }

        public HtmlToPdfClient setHeaderHeight(String headerHeight) {
            if (!headerHeight.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(headerHeight, "header_height", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_header_height"), 470);
            }
            this.fields.put("header_height", headerHeight);
            return this;
        }

        public HtmlToPdfClient setFooterUrl(String footerUrl) {
            if (!footerUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(footerUrl, "footer_url", "html-to-pdf", "The supported protocols are http:// and https://.", "set_footer_url"), 470);
            }
            this.fields.put("footer_url", footerUrl);
            return this;
        }

        public HtmlToPdfClient setFooterHtml(String footerHtml) {
            if (footerHtml == null || footerHtml.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(footerHtml, "footer_html", "html-to-pdf", "The string must not be empty.", "set_footer_html"), 470);
            }
            this.fields.put("footer_html", footerHtml);
            return this;
        }

        public HtmlToPdfClient setFooterHeight(String footerHeight) {
            if (!footerHeight.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(footerHeight, "footer_height", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_footer_height"), 470);
            }
            this.fields.put("footer_height", footerHeight);
            return this;
        }

        public HtmlToPdfClient setPrintPageRange(String pages) {
            if (!pages.matches("^(?:\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*,\\s*)*\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "pages", "html-to-pdf", "A comma seperated list of page numbers or ranges.", "set_print_page_range"), 470);
            }
            this.fields.put("print_page_range", pages);
            return this;
        }

        public HtmlToPdfClient setExcludeHeaderOnPages(String pages) {
            if (!pages.matches("^(?:\\s*\\-?\\d+\\s*,)*\\s*\\-?\\d+\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "pages", "html-to-pdf", "A comma seperated list of page numbers.", "set_exclude_header_on_pages"), 470);
            }
            this.fields.put("exclude_header_on_pages", pages);
            return this;
        }

        public HtmlToPdfClient setExcludeFooterOnPages(String pages) {
            if (!pages.matches("^(?:\\s*\\-?\\d+\\s*,)*\\s*\\-?\\d+\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "pages", "html-to-pdf", "A comma seperated list of page numbers.", "set_exclude_footer_on_pages"), 470);
            }
            this.fields.put("exclude_footer_on_pages", pages);
            return this;
        }

        public HtmlToPdfClient setPageNumberingOffset(int offset) {
            this.fields.put("page_numbering_offset", Integer.toString(offset));
            return this;
        }

        public HtmlToPdfClient setContentAreaX(String contentAreaX) {
            if (!contentAreaX.matches("(?i)^\\-?[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(contentAreaX, "content_area_x", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt). It may contain a negative value.", "set_content_area_x"), 470);
            }
            this.fields.put("content_area_x", contentAreaX);
            return this;
        }

        public HtmlToPdfClient setContentAreaY(String contentAreaY) {
            if (!contentAreaY.matches("(?i)^\\-?[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(contentAreaY, "content_area_y", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt). It may contain a negative value.", "set_content_area_y"), 470);
            }
            this.fields.put("content_area_y", contentAreaY);
            return this;
        }

        public HtmlToPdfClient setContentAreaWidth(String contentAreaWidth) {
            if (!contentAreaWidth.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(contentAreaWidth, "content_area_width", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_content_area_width"), 470);
            }
            this.fields.put("content_area_width", contentAreaWidth);
            return this;
        }

        public HtmlToPdfClient setContentAreaHeight(String contentAreaHeight) {
            if (!contentAreaHeight.matches("(?i)^[0-9]*(\\.[0-9]+)?(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(contentAreaHeight, "content_area_height", "html-to-pdf", "Can be specified in inches (in), millimeters (mm), centimeters (cm), or points (pt).", "set_content_area_height"), 470);
            }
            this.fields.put("content_area_height", contentAreaHeight);
            return this;
        }

        public HtmlToPdfClient setContentArea(String x, String y, String width, String height) {
            this.setContentAreaX(x);
            this.setContentAreaY(y);
            this.setContentAreaWidth(width);
            this.setContentAreaHeight(height);
            return this;
        }

        public HtmlToPdfClient setPageWatermark(String pageWatermark) {
            if (new File(pageWatermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageWatermark, "page_watermark", "html-to-pdf", "The file must exist and not be empty.", "set_page_watermark"), 470);
            }
            this.files.put("page_watermark", pageWatermark);
            return this;
        }

        public HtmlToPdfClient setPageWatermarkUrl(String pageWatermarkUrl) {
            if (!pageWatermarkUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageWatermarkUrl, "page_watermark_url", "html-to-pdf", "The supported protocols are http:// and https://.", "set_page_watermark_url"), 470);
            }
            this.fields.put("page_watermark_url", pageWatermarkUrl);
            return this;
        }

        public HtmlToPdfClient setMultipageWatermark(String multipageWatermark) {
            if (new File(multipageWatermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageWatermark, "multipage_watermark", "html-to-pdf", "The file must exist and not be empty.", "set_multipage_watermark"), 470);
            }
            this.files.put("multipage_watermark", multipageWatermark);
            return this;
        }

        public HtmlToPdfClient setMultipageWatermarkUrl(String multipageWatermarkUrl) {
            if (!multipageWatermarkUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageWatermarkUrl, "multipage_watermark_url", "html-to-pdf", "The supported protocols are http:// and https://.", "set_multipage_watermark_url"), 470);
            }
            this.fields.put("multipage_watermark_url", multipageWatermarkUrl);
            return this;
        }

        public HtmlToPdfClient setPageBackground(String pageBackground) {
            if (new File(pageBackground).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageBackground, "page_background", "html-to-pdf", "The file must exist and not be empty.", "set_page_background"), 470);
            }
            this.files.put("page_background", pageBackground);
            return this;
        }

        public HtmlToPdfClient setPageBackgroundUrl(String pageBackgroundUrl) {
            if (!pageBackgroundUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageBackgroundUrl, "page_background_url", "html-to-pdf", "The supported protocols are http:// and https://.", "set_page_background_url"), 470);
            }
            this.fields.put("page_background_url", pageBackgroundUrl);
            return this;
        }

        public HtmlToPdfClient setMultipageBackground(String multipageBackground) {
            if (new File(multipageBackground).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageBackground, "multipage_background", "html-to-pdf", "The file must exist and not be empty.", "set_multipage_background"), 470);
            }
            this.files.put("multipage_background", multipageBackground);
            return this;
        }

        public HtmlToPdfClient setMultipageBackgroundUrl(String multipageBackgroundUrl) {
            if (!multipageBackgroundUrl.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(multipageBackgroundUrl, "multipage_background_url", "html-to-pdf", "The supported protocols are http:// and https://.", "set_multipage_background_url"), 470);
            }
            this.fields.put("multipage_background_url", multipageBackgroundUrl);
            return this;
        }

        public HtmlToPdfClient setPageBackgroundColor(String pageBackgroundColor) {
            if (!pageBackgroundColor.matches("^[0-9a-fA-F]{6,8}$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageBackgroundColor, "page_background_color", "html-to-pdf", "The value must be in RRGGBB or RRGGBBAA hexadecimal format.", "set_page_background_color"), 470);
            }
            this.fields.put("page_background_color", pageBackgroundColor);
            return this;
        }

        public HtmlToPdfClient setNoBackground(boolean noBackground) {
            this.fields.put("no_background", noBackground ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisableJavascript(boolean disableJavascript) {
            this.fields.put("disable_javascript", disableJavascript ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisableImageLoading(boolean disableImageLoading) {
            this.fields.put("disable_image_loading", disableImageLoading ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisableRemoteFonts(boolean disableRemoteFonts) {
            this.fields.put("disable_remote_fonts", disableRemoteFonts ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setBlockAds(boolean blockAds) {
            this.fields.put("block_ads", blockAds ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDefaultEncoding(String defaultEncoding) {
            this.fields.put("default_encoding", defaultEncoding);
            return this;
        }

        public HtmlToPdfClient setHttpAuthUserName(String userName) {
            this.fields.put("http_auth_user_name", userName);
            return this;
        }

        public HtmlToPdfClient setHttpAuthPassword(String password) {
            this.fields.put("http_auth_password", password);
            return this;
        }

        public HtmlToPdfClient setHttpAuth(String userName, String password) {
            this.setHttpAuthUserName(userName);
            this.setHttpAuthPassword(password);
            return this;
        }

        public HtmlToPdfClient setUsePrintMedia(boolean usePrintMedia) {
            this.fields.put("use_print_media", usePrintMedia ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoXpdfcrowdHeader(boolean noXpdfcrowdHeader) {
            this.fields.put("no_xpdfcrowd_header", noXpdfcrowdHeader ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setCookies(String cookies) {
            this.fields.put("cookies", cookies);
            return this;
        }

        public HtmlToPdfClient setVerifySslCertificates(boolean verifySslCertificates) {
            this.fields.put("verify_ssl_certificates", verifySslCertificates ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setFailOnMainUrlError(boolean failOnError) {
            this.fields.put("fail_on_main_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setFailOnAnyUrlError(boolean failOnError) {
            this.fields.put("fail_on_any_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setCustomJavascript(String customJavascript) {
            if (customJavascript == null || customJavascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(customJavascript, "custom_javascript", "html-to-pdf", "The string must not be empty.", "set_custom_javascript"), 470);
            }
            this.fields.put("custom_javascript", customJavascript);
            return this;
        }

        public HtmlToPdfClient setOnLoadJavascript(String onLoadJavascript) {
            if (onLoadJavascript == null || onLoadJavascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(onLoadJavascript, "on_load_javascript", "html-to-pdf", "The string must not be empty.", "set_on_load_javascript"), 470);
            }
            this.fields.put("on_load_javascript", onLoadJavascript);
            return this;
        }

        public HtmlToPdfClient setCustomHttpHeader(String customHttpHeader) {
            if (!customHttpHeader.matches("^.+:.+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(customHttpHeader, "custom_http_header", "html-to-pdf", "A string containing the header name and value separated by a colon.", "set_custom_http_header"), 470);
            }
            this.fields.put("custom_http_header", customHttpHeader);
            return this;
        }

        public HtmlToPdfClient setJavascriptDelay(int javascriptDelay) {
            if (javascriptDelay < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(javascriptDelay, "javascript_delay", "html-to-pdf", "Must be a positive integer number or 0.", "set_javascript_delay"), 470);
            }
            this.fields.put("javascript_delay", Integer.toString(javascriptDelay));
            return this;
        }

        public HtmlToPdfClient setElementToConvert(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "selectors", "html-to-pdf", "The string must not be empty.", "set_element_to_convert"), 470);
            }
            this.fields.put("element_to_convert", selectors);
            return this;
        }

        public HtmlToPdfClient setElementToConvertMode(String mode) {
            if (!mode.matches("(?i)^(cut-out|remove-siblings|hide-siblings)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "mode", "html-to-pdf", "Allowed values are cut-out, remove-siblings, hide-siblings.", "set_element_to_convert_mode"), 470);
            }
            this.fields.put("element_to_convert_mode", mode);
            return this;
        }

        public HtmlToPdfClient setWaitForElement(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "selectors", "html-to-pdf", "The string must not be empty.", "set_wait_for_element"), 470);
            }
            this.fields.put("wait_for_element", selectors);
            return this;
        }

        public HtmlToPdfClient setViewportWidth(int viewportWidth) {
            if (viewportWidth < 96 || viewportWidth > 65000) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(viewportWidth, "viewport_width", "html-to-pdf", "The value must be in the range 96-65000.", "set_viewport_width"), 470);
            }
            this.fields.put("viewport_width", Integer.toString(viewportWidth));
            return this;
        }

        public HtmlToPdfClient setViewportHeight(int viewportHeight) {
            if (viewportHeight <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(viewportHeight, "viewport_height", "html-to-pdf", "Must be a positive integer number.", "set_viewport_height"), 470);
            }
            this.fields.put("viewport_height", Integer.toString(viewportHeight));
            return this;
        }

        public HtmlToPdfClient setViewport(int width, int height) {
            this.setViewportWidth(width);
            this.setViewportHeight(height);
            return this;
        }

        public HtmlToPdfClient setRenderingMode(String renderingMode) {
            if (!renderingMode.matches("(?i)^(default|viewport)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(renderingMode, "rendering_mode", "html-to-pdf", "Allowed values are default, viewport.", "set_rendering_mode"), 470);
            }
            this.fields.put("rendering_mode", renderingMode);
            return this;
        }

        public HtmlToPdfClient setSmartScalingMode(String smartScalingMode) {
            if (!smartScalingMode.matches("(?i)^(default|disabled|viewport-fit|content-fit|single-page-fit)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(smartScalingMode, "smart_scaling_mode", "html-to-pdf", "Allowed values are default, disabled, viewport-fit, content-fit, single-page-fit.", "set_smart_scaling_mode"), 470);
            }
            this.fields.put("smart_scaling_mode", smartScalingMode);
            return this;
        }

        public HtmlToPdfClient setScaleFactor(int scaleFactor) {
            if (scaleFactor < 10 || scaleFactor > 500) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(scaleFactor, "scale_factor", "html-to-pdf", "The value must be in the range 10-500.", "set_scale_factor"), 470);
            }
            this.fields.put("scale_factor", Integer.toString(scaleFactor));
            return this;
        }

        public HtmlToPdfClient setHeaderFooterScaleFactor(int headerFooterScaleFactor) {
            if (headerFooterScaleFactor < 10 || headerFooterScaleFactor > 500) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(headerFooterScaleFactor, "header_footer_scale_factor", "html-to-pdf", "The value must be in the range 10-500.", "set_header_footer_scale_factor"), 470);
            }
            this.fields.put("header_footer_scale_factor", Integer.toString(headerFooterScaleFactor));
            return this;
        }

        public HtmlToPdfClient setDisableSmartShrinking(boolean disableSmartShrinking) {
            this.fields.put("disable_smart_shrinking", disableSmartShrinking ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setJpegQuality(int jpegQuality) {
            if (jpegQuality < 1 || jpegQuality > 100) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(jpegQuality, "jpeg_quality", "html-to-pdf", "The value must be in the range 1-100.", "set_jpeg_quality"), 470);
            }
            this.fields.put("jpeg_quality", Integer.toString(jpegQuality));
            return this;
        }

        public HtmlToPdfClient setConvertImagesToJpeg(String convertImagesToJpeg) {
            if (!convertImagesToJpeg.matches("(?i)^(none|opaque|all)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(convertImagesToJpeg, "convert_images_to_jpeg", "html-to-pdf", "Allowed values are none, opaque, all.", "set_convert_images_to_jpeg"), 470);
            }
            this.fields.put("convert_images_to_jpeg", convertImagesToJpeg);
            return this;
        }

        public HtmlToPdfClient setImageDpi(int imageDpi) {
            if (imageDpi < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(imageDpi, "image_dpi", "html-to-pdf", "Must be a positive integer number or 0.", "set_image_dpi"), 470);
            }
            this.fields.put("image_dpi", Integer.toString(imageDpi));
            return this;
        }

        public HtmlToPdfClient setLinearize(boolean linearize) {
            this.fields.put("linearize", linearize ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setEncrypt(boolean encrypt) {
            this.fields.put("encrypt", encrypt ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setUserPassword(String userPassword) {
            this.fields.put("user_password", userPassword);
            return this;
        }

        public HtmlToPdfClient setOwnerPassword(String ownerPassword) {
            this.fields.put("owner_password", ownerPassword);
            return this;
        }

        public HtmlToPdfClient setNoPrint(boolean noPrint) {
            this.fields.put("no_print", noPrint ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoModify(boolean noModify) {
            this.fields.put("no_modify", noModify ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoCopy(boolean noCopy) {
            this.fields.put("no_copy", noCopy ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setTitle(String title) {
            this.fields.put("title", title);
            return this;
        }

        public HtmlToPdfClient setSubject(String subject) {
            this.fields.put("subject", subject);
            return this;
        }

        public HtmlToPdfClient setAuthor(String author) {
            this.fields.put("author", author);
            return this;
        }

        public HtmlToPdfClient setKeywords(String keywords) {
            this.fields.put("keywords", keywords);
            return this;
        }

        public HtmlToPdfClient setPageLayout(String pageLayout) {
            if (!pageLayout.matches("(?i)^(single-page|one-column|two-column-left|two-column-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageLayout, "page_layout", "html-to-pdf", "Allowed values are single-page, one-column, two-column-left, two-column-right.", "set_page_layout"), 470);
            }
            this.fields.put("page_layout", pageLayout);
            return this;
        }

        public HtmlToPdfClient setPageMode(String pageMode) {
            if (!pageMode.matches("(?i)^(full-screen|thumbnails|outlines)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pageMode, "page_mode", "html-to-pdf", "Allowed values are full-screen, thumbnails, outlines.", "set_page_mode"), 470);
            }
            this.fields.put("page_mode", pageMode);
            return this;
        }

        public HtmlToPdfClient setInitialZoomType(String initialZoomType) {
            if (!initialZoomType.matches("(?i)^(fit-width|fit-height|fit-page)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(initialZoomType, "initial_zoom_type", "html-to-pdf", "Allowed values are fit-width, fit-height, fit-page.", "set_initial_zoom_type"), 470);
            }
            this.fields.put("initial_zoom_type", initialZoomType);
            return this;
        }

        public HtmlToPdfClient setInitialPage(int initialPage) {
            if (initialPage <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(initialPage, "initial_page", "html-to-pdf", "Must be a positive integer number.", "set_initial_page"), 470);
            }
            this.fields.put("initial_page", Integer.toString(initialPage));
            return this;
        }

        public HtmlToPdfClient setInitialZoom(int initialZoom) {
            if (initialZoom <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(initialZoom, "initial_zoom", "html-to-pdf", "Must be a positive integer number.", "set_initial_zoom"), 470);
            }
            this.fields.put("initial_zoom", Integer.toString(initialZoom));
            return this;
        }

        public HtmlToPdfClient setHideToolbar(boolean hideToolbar) {
            this.fields.put("hide_toolbar", hideToolbar ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setHideMenubar(boolean hideMenubar) {
            this.fields.put("hide_menubar", hideMenubar ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setHideWindowUi(boolean hideWindowUi) {
            this.fields.put("hide_window_ui", hideWindowUi ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setFitWindow(boolean fitWindow) {
            this.fields.put("fit_window", fitWindow ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setCenterWindow(boolean centerWindow) {
            this.fields.put("center_window", centerWindow ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisplayTitle(boolean displayTitle) {
            this.fields.put("display_title", displayTitle ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setRightToLeft(boolean rightToLeft) {
            this.fields.put("right_to_left", rightToLeft ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDebugLog(boolean debugLog) {
            this.fields.put("debug_log", debugLog ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public HtmlToPdfClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public HtmlToPdfClient setHttpProxy(String httpProxy) {
            if (!httpProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpProxy, "http_proxy", "html-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", httpProxy);
            return this;
        }

        public HtmlToPdfClient setHttpsProxy(String httpsProxy) {
            if (!httpsProxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(httpsProxy, "https_proxy", "html-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", httpsProxy);
            return this;
        }

        public HtmlToPdfClient setClientCertificate(String clientCertificate) {
            if (new File(clientCertificate).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(clientCertificate, "client_certificate", "html-to-pdf", "The file must exist and not be empty.", "set_client_certificate"), 470);
            }
            this.files.put("client_certificate", clientCertificate);
            return this;
        }

        public HtmlToPdfClient setClientCertificatePassword(String clientCertificatePassword) {
            this.fields.put("client_certificate_password", clientCertificatePassword);
            return this;
        }

        public HtmlToPdfClient setUseHttp(boolean useHttp) {
            this.helper.setUseHttp(useHttp);
            return this;
        }

        public HtmlToPdfClient setUserAgent(String userAgent) {
            this.helper.setUserAgent(userAgent);
            return this;
        }

        public HtmlToPdfClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public HtmlToPdfClient setRetryCount(int retryCount) {
            this.helper.setRetryCount(retryCount);
            return this;
        }
    }

    private static final class ConnectionHelper {
        private String userName;
        private String apiKey;
        private int port;
        private boolean useHttp;
        private String userAgent;
        private String debugLogUrl;
        private int credits;
        private int consumedCredits;
        private String jobId;
        private int pageCount;
        private int outputSize;
        private String proxyHost;
        private int proxyPort;
        private String proxyUserName;
        private String proxyPassword;
        private int retryCount;
        private int retry;
        private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return hostname.equals("api.pdfcrowd.com") || !HOST.equals("api.pdfcrowd.com");
            }
        };

        ConnectionHelper(String userName, String apiKey) {
            this.userName = userName;
            this.apiKey = apiKey;
            this.resetResponseData();
            this.setProxy(null, 0, null, null);
            this.setUseHttp(false);
            this.setUserAgent("pdfcrowd_java_client/4.11.0 (http://pdfcrowd.com)");
            this.retryCount = 1;
        }

        private void resetResponseData() {
            this.debugLogUrl = null;
            this.credits = 999999;
            this.consumedCredits = 0;
            this.jobId = "";
            this.pageCount = 0;
            this.outputSize = 0;
            this.retry = 0;
        }

        private static void copyStream(InputStream in, OutputStream out) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }

        private static String join(AbstractCollection<String> col, String delimiter) {
            if (col.isEmpty()) {
                return "";
            }
            Iterator<String> iter = col.iterator();
            StringBuffer buffer = new StringBuffer(iter.next());
            while (iter.hasNext()) {
                buffer.append(delimiter).append(iter.next());
            }
            return buffer.toString();
        }

        private static HashMap<String, String> prepareFields(HashMap<String, String> fields) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                String value = entry.getValue();
                if (value == null || value.isEmpty()) continue;
                result.put(entry.getKey(), value);
            }
            return result;
        }

        byte[] post(HashMap<String, String> fields, HashMap<String, String> files, HashMap<String, byte[]> rawData, OutputStream outStream) {
            ByteArrayOutputStream body = ConnectionHelper.encodeMultipartPostData(ConnectionHelper.prepareFields(fields), files, rawData);
            String contentType = "multipart/form-data; boundary=----------ThIs_Is_tHe_bOUnDary_$";
            return this.doPost(body, contentType, outStream);
        }

        private static void beginFileField(String name, String fileName, Vector<String> body) {
            body.add("------------ThIs_Is_tHe_bOUnDary_$");
            body.add(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", name, fileName));
            body.add("Content-Type: application/octet-stream");
            body.add("");
            body.add("");
        }

        private static ByteArrayOutputStream encodeMultipartPostData(HashMap<String, String> fields, HashMap<String, String> files, HashMap<String, byte[]> rawData) {
            try {
                Vector<String> body = new Vector<String>();
                ByteArrayOutputStream retval = new ByteArrayOutputStream();
                for (Map.Entry<String, String> entry : fields.entrySet()) {
                    body.add("------------ThIs_Is_tHe_bOUnDary_$");
                    body.add(String.format("Content-Disposition: form-data; name=\"%s\"", entry.getKey()));
                    body.add("");
                    body.add(entry.getValue());
                }
                for (Map.Entry<String, String> entry : files.entrySet()) {
                    ConnectionHelper.beginFileField(entry.getKey(), entry.getValue(), body);
                    retval.write(ConnectionHelper.join(body, "\r\n").getBytes("UTF-8"));
                    body.clear();
                    ConnectionHelper.copyStream(new FileInputStream(entry.getValue()), retval);
                    retval.write("\r\n".getBytes("UTF-8"));
                }
                for (Map.Entry<String, String> entry : rawData.entrySet()) {
                    ConnectionHelper.beginFileField(entry.getKey(), entry.getKey(), body);
                    retval.write(ConnectionHelper.join(body, "\r\n").getBytes("UTF-8"));
                    body.clear();
                    retval.write((byte[])entry.getValue());
                    retval.write("\r\n".getBytes("UTF-8"));
                }
                body.add("------------ThIs_Is_tHe_bOUnDary_$--");
                body.add("");
                retval.write(ConnectionHelper.join(body, "\r\n").getBytes("UTF-8"));
                return retval;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        private HttpURLConnection getConnection(String contentType) throws IOException {
            try {
                URL url = new URL(String.format("http%s://%s:%d%s", this.useHttp ? "" : "s", HOST, this.port, "/convert/"));
                HttpURLConnection conn = null;
                if (this.proxyHost != null) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
                    conn = (HttpURLConnection)url.openConnection(proxy);
                    if (this.proxyUserName != null) {
                        Authenticator authenticator = new Authenticator(){

                            @Override
                            public PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(ConnectionHelper.this.proxyUserName, ConnectionHelper.this.proxyPassword.toCharArray());
                            }
                        };
                        Authenticator.setDefault(authenticator);
                    }
                } else {
                    conn = (HttpURLConnection)url.openConnection();
                    if (!this.useHttp && conn instanceof HttpsURLConnection) {
                        HttpsURLConnection ssl_conn = (HttpsURLConnection)conn;
                        ssl_conn.setHostnameVerifier(HOSTNAME_VERIFIER);
                    }
                }
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", contentType);
                conn.setRequestProperty("User-Agent", this.userAgent);
                String auth = this.userName + ':' + this.apiKey;
                String authEncoded = new String(Base64Utils.encodeBytes(auth.getBytes()));
                conn.setRequestProperty("Authorization", "Basic " + authEncoded);
                return conn;
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }

        private static int getIntHeader(HttpURLConnection conn, String name, int defaultValue) {
            String value = conn.getHeaderField(name);
            return value == null ? defaultValue : Integer.parseInt(value);
        }

        private static String getStringHeader(HttpURLConnection conn, String name, String defaultValue) {
            String value = conn.getHeaderField(name);
            return value == null ? defaultValue : value;
        }

        private byte[] doPost(Object body, String contentType, OutputStream outStream) {
            if (!this.useHttp && this.proxyHost != null) {
                throw new Error("HTTPS over a proxy is not supported.");
            }
            this.resetResponseData();
            while (true) {
                try {
                    return this.execRequest(body, contentType, outStream);
                }
                catch (Error err) {
                    if (err.getCode() == 502 && this.retryCount > this.retry) {
                        ++this.retry;
                        try {
                            Thread.sleep(this.retry * 100);
                        }
                        catch (InterruptedException e) {
                            throw err;
                        }
                        continue;
                    }
                    throw err;
                }
                break;
            }
        }

        private byte[] execRequest(Object body, String contentType, OutputStream outStream) {
            try {
                int bytesRead;
                HttpURLConnection conn = this.getConnection(contentType);
                OutputStream wr = conn.getOutputStream();
                if (body instanceof byte[]) {
                    wr.write((byte[])body);
                } else {
                    ((ByteArrayOutputStream)body).writeTo(wr);
                }
                wr.flush();
                wr.close();
                this.debugLogUrl = ConnectionHelper.getStringHeader(conn, "X-Pdfcrowd-Debug-Log", "");
                this.credits = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Remaining-Credits", 999999);
                this.consumedCredits = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Consumed-Credits", 0);
                this.jobId = ConnectionHelper.getStringHeader(conn, "X-Pdfcrowd-Job-Id", "");
                this.pageCount = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Pages", 0);
                this.outputSize = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Output-Size", 0);
                if (System.getenv("PDFCROWD_UNIT_TEST_MODE") != null && this.retryCount > this.retry) {
                    throw new Error("test 502", 502);
                }
                if (conn.getResponseCode() > 299) {
                    String errMsg;
                    if (conn.getErrorStream() != null) {
                        ByteArrayOutputStream errOut = new ByteArrayOutputStream();
                        ConnectionHelper.copyStream(conn.getErrorStream(), errOut);
                        errMsg = errOut.toString();
                    } else {
                        errMsg = conn.getResponseMessage();
                    }
                    throw new Error(errMsg, conn.getResponseCode());
                }
                InputStream inStream = conn.getInputStream();
                if (outStream != null) {
                    ConnectionHelper.copyStream(inStream, outStream);
                    inStream.close();
                    return null;
                }
                byte[] buffer = new byte[16384];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((bytesRead = inStream.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                inStream.close();
                return output.toByteArray();
            }
            catch (SSLException e) {
                throw new Error("There was a problem connecting to Pdfcrowd servers over HTTPS:\n" + e.toString() + "\nYou can still use the API over HTTP, you just need to add the following line right after Pdfcrowd client initialization:\nclient.setUseHttp(true);", 481);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        void setUseHttp(boolean useHttp) {
            this.useHttp = useHttp;
            this.port = useHttp ? 80 : 443;
        }

        void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        void setProxy(String host, int port, String userName, String password) {
            this.proxyHost = host;
            this.proxyPort = port;
            this.proxyUserName = userName;
            this.proxyPassword = password;
        }

        String getDebugLogUrl() {
            return this.debugLogUrl;
        }

        int getRemainingCreditCount() {
            return this.credits;
        }

        int getConsumedCreditCount() {
            return this.consumedCredits;
        }

        String getJobId() {
            return this.jobId;
        }

        int getPageCount() {
            return this.pageCount;
        }

        int getOutputSize() {
            return this.outputSize;
        }
    }

    public static final class Error
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public int statusCode = 0;

        public Error() {
        }

        public Error(Throwable throwable) {
            super(throwable);
        }

        public Error(String msg) {
            super(msg);
        }

        public Error(String msg, int code) {
            super(msg);
            this.statusCode = code;
        }

        @Override
        public String toString() {
            if (this.statusCode == 0) {
                return this.getMessage();
            }
            StringBuffer message = new StringBuffer(Integer.toString(this.statusCode));
            message.append(" - ").append(this.getMessage());
            return message.toString();
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }

        public int getCode() {
            return this.statusCode;
        }
    }
}

