/*
 * Decompiled with CFR 0.152.
 */
package com.pdfcrowd;

import com.pdfcrowd.PdfcrowdError;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class Client {
    private HashMap<String, String> fields;
    private boolean m_useSSL = false;
    public static int SINGLE_PAGE = 1;
    public static int CONTINUOUS = 2;
    public static int CONTINUOUS_FACING = 3;
    public static int NONE_VISIBLE = 1;
    public static int THUMBNAILS_VISIBLE = 2;
    public static int FULLSCREEN = 3;
    public static int FIT_WIDTH = 1;
    public static int FIT_HEIGHT = 2;
    public static int FIT_PAGE = 3;
    private static String URLENCODED = new String("application/x-www-form-urlencoded");
    private static String MULTIPART_BOUNDARY = new String("----------ThIs_Is_tHe_bOUnDary_$");
    private static String MULTIPART = new String("multipart/form-data; boundary=" + MULTIPART_BOUNDARY);
    public static String API_HOSTNAME = new String("pdfcrowd.com");
    public static int API_HTTP_PORT = 80;
    public static int API_HTTPS_PORT = 443;
    private String api_hostname;
    private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public Client(String username, String apikey) {
        this.init(username, apikey, API_HOSTNAME);
    }

    public void convertURI(String uri, OutputStream outStream) {
        byte[] data = this.encodePostData(uri);
        this.callAPI(data, "pdf/convert/uri/", outStream, URLENCODED);
    }

    public void convertHtml(String html, OutputStream outStream) {
        byte[] data = this.encodePostData(html);
        this.callAPI(data, "pdf/convert/html/", outStream, URLENCODED);
    }

    public void convertFile(String path, OutputStream outStream) {
        ByteArrayOutputStream data = this.encodeMultipartPostData(path);
        this.callAPI(data, "pdf/convert/html/", outStream, MULTIPART);
    }

    public int numTokens() {
        byte[] data = this.encodePostData(null);
        ByteArrayOutputStream tokens = new ByteArrayOutputStream();
        this.callAPI(data, "user/" + this.fields.get("username") + "/tokens/", tokens, URLENCODED);
        return Integer.parseInt(tokens.toString());
    }

    public void useSSL(boolean val) {
        this.m_useSSL = val;
    }

    public void setUsername(String username) {
        this.fields.put("username", username);
    }

    public void setApiKey(String key) {
        this.fields.put("key", key);
    }

    public void setPageWidth(double value) {
        this.fields.put("width", this.doubleToString(value));
    }

    public void setPageWidth(String value) {
        this.fields.put("width", value);
    }

    public void setPageHeight(double value) {
        this.fields.put("height", this.doubleToString(value));
    }

    public void setPageHeight(String value) {
        this.fields.put("height", value);
    }

    public void setHorizontalMargin(double value) {
        this.fields.put("margin_right", this.doubleToString(value));
        this.fields.put("margin_left", this.doubleToString(value));
    }

    public void setHorizontalMargin(String value) {
        this.fields.put("margin_right", value);
        this.fields.put("margin_left", value);
    }

    public void setVerticalMargin(double value) {
        this.fields.put("margin_top", this.doubleToString(value));
        this.fields.put("margin_bottom", this.doubleToString(value));
    }

    public void setVerticalMargin(String value) {
        this.fields.put("margin_top", value);
        this.fields.put("margin_bottom", value);
    }

    public void setPageMargins(String top, String right, String bottom, String left) {
        this.fields.put("margin_top", top);
        this.fields.put("margin_right", right);
        this.fields.put("margin_bottom", bottom);
        this.fields.put("margin_left", left);
    }

    public void setEncrypted() {
        this.setEncrypted(true);
    }

    public void setEncrypted(boolean value) {
        this.fields.put("encrypted", value ? "true" : null);
    }

    public void setUserPassword(String pwd) {
        this.fields.put("user_pwd", pwd);
    }

    public void setOwnerPassword(String pwd) {
        this.fields.put("owner_pwd", pwd);
    }

    public void setNoPrint() {
        this.setNoPrint(true);
    }

    public void setNoPrint(boolean val) {
        this.fields.put("no_print", val ? "true" : null);
    }

    public void setNoModify() {
        this.setNoModify(true);
    }

    public void setNoModify(boolean val) {
        this.fields.put("no_modify", val ? "true" : null);
    }

    public void setNoCopy() {
        this.setNoCopy(true);
    }

    public void setNoCopy(boolean val) {
        this.fields.put("no_copy", val ? "true" : null);
    }

    public void setPageLayout(int value) {
        assert (value > 0 && value <= 3);
        this.fields.put("page_layout", Integer.toString(value));
    }

    public void setPageMode(int value) {
        assert (value > 0 && value <= 3);
        this.fields.put("page_mode", Integer.toString(value));
    }

    public void setFooterText(String value) {
        this.fields.put("footer_text", value);
    }

    public void enableImages() {
        this.enableImages(true);
    }

    public void enableImages(boolean value) {
        this.fields.put("no_images", value ? null : "true");
    }

    public void enableBackgrounds() {
        this.enableBackgrounds(true);
    }

    public void enableBackgrounds(boolean value) {
        this.fields.put("no_backgrounds", value ? null : "true");
    }

    public void setHtmlZoom(double value) {
        this.fields.put("html_zoom", Double.toString(value));
    }

    public void enableJavaScript() {
        this.enableJavaScript(true);
    }

    public void enableJavaScript(boolean value) {
        this.fields.put("no_javascript", value ? null : "true");
    }

    public void enableHyperlinks() {
        this.enableHyperlinks(true);
    }

    public void enableHyperlinks(boolean value) {
        this.fields.put("no_hyperlinks", value ? null : "true");
    }

    public void setDefaultTextEncoding(String value) {
        this.fields.put("text_encoding", value);
    }

    public void usePrintMedia() {
        this.usePrintMedia(true);
    }

    public void usePrintMedia(boolean value) {
        this.fields.put("use_print_media", value ? "true" : null);
    }

    public void setMaxPages(int value) {
        this.fields.put("max_pages", Integer.toString(value));
    }

    public void enablePdfcrowdLogo() {
        this.enablePdfcrowdLogo(true);
    }

    public void enablePdfcrowdLogo(boolean value) {
        this.fields.put("pdfcrowd_logo", value ? "true" : null);
    }

    public void setInitialPdfZoomType(int value) {
        assert (value > 0 && value <= 3);
        this.fields.put("initial_pdf_zoom_type", Integer.toString(value));
    }

    public void setInitialPdfExactZoom(double value) {
        this.fields.put("initial_pdf_zoom_type", "4");
        this.fields.put("initial_pdf_zoom", Double.toString(value));
    }

    public Client(String username, String apikey, String api_hostname) {
        this.init(username, apikey, api_hostname);
    }

    public void setAuthor(String value) {
        this.fields.put("author", value);
    }

    public void setFailOnNon200(boolean value) {
        this.fields.put("fail_on_non200", value ? "true" : null);
    }

    public void setPdfScalingFactor(double value) {
        this.fields.put("pdf_scaling_factor", this.doubleToString(value));
    }

    public void setFooterHtml(String value) {
        this.fields.put("footer_html", value);
    }

    public void setFooterUrl(String value) {
        this.fields.put("footer_url", value);
    }

    public void setHeaderHtml(String value) {
        this.fields.put("header_html", value);
    }

    public void setHeaderUrl(String value) {
        this.fields.put("header_url", value);
    }

    public void setPageBackgroundColor(String value) {
        this.fields.put("page_background_color", value);
    }

    public void setTransparentBackground() {
        this.setTransparentBackground(true);
    }

    public void setTransparentBackground(boolean val) {
        this.fields.put("transparent_background", val ? "true" : null);
    }

    public void setPageNumberingOffset(int value) {
        this.fields.put("page_numbering_offset", Integer.toString(value));
    }

    public void setHeaderFooterPageExcludeList(String value) {
        this.fields.put("header_footer_page_exclude_list", value);
    }

    public void setWatermark(String url, double offset_x, double offset_y) {
        this.fields.put("watermark_url", url);
        this.fields.put("watermark_offset_x", Double.toString(offset_x));
        this.fields.put("watermark_offset_y", Double.toString(offset_y));
    }

    public void setWatermark(String url, String offset_x, String offset_y) {
        this.fields.put("watermark_url", url);
        this.fields.put("watermark_offset_x", offset_x);
        this.fields.put("watermark_offset_y", offset_y);
    }

    public void setWatermarkRotation(double angle) {
        this.fields.put("watermark_rotation", Double.toString(angle));
    }

    public void setWatermarkInBackground() {
        this.setWatermarkInBackground(true);
    }

    public void setWatermarkInBackground(boolean val) {
        this.fields.put("watermark_in_background", val ? "true" : null);
    }

    private void init(String username, String apikey, String apihost) {
        this.fields = new HashMap();
        this.fields.put("username", username);
        this.fields.put("key", apikey);
        this.fields.put("pdf_scaling_factor", "1.0");
        this.fields.put("html_zoom", "200");
        this.api_hostname = apihost;
    }

    private String doubleToString(double val) {
        return String.format(Locale.US, "%.5f", val);
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private static String join(AbstractCollection<String> col, String delimiter) {
        if (col.isEmpty()) {
            return "";
        }
        Iterator<String> iter = col.iterator();
        StringBuffer buffer = new StringBuffer(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        return buffer.toString();
    }

    private String getBaseUri() {
        if (this.m_useSSL) {
            return String.format("https://%s:%d/api/", this.api_hostname, API_HTTPS_PORT);
        }
        return String.format("http://%s:%d/api/", this.api_hostname, API_HTTP_PORT);
    }

    private HttpURLConnection getConnection(String uriSuffix, String contentType) throws IOException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.getBaseUri() + uriSuffix).openConnection();
            if (this.m_useSSL && conn instanceof HttpsURLConnection) {
                HttpsURLConnection ssl_conn = (HttpsURLConnection)conn;
                ssl_conn.setHostnameVerifier(HOSTNAME_VERIFIER);
            }
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", contentType);
            conn.setConnectTimeout(120000);
            return conn;
        }
        catch (MalformedURLException e) {
            throw new PdfcrowdError(e);
        }
    }

    private void callAPI(Object data, String uriSuffix, OutputStream outStream, String contentType) {
        try {
            HttpURLConnection conn = this.getConnection(uriSuffix, contentType);
            OutputStream wr = conn.getOutputStream();
            if (data instanceof byte[]) {
                wr.write((byte[])data);
            } else {
                ((ByteArrayOutputStream)data).writeTo(wr);
            }
            wr.flush();
            if (conn.getResponseCode() != 200) {
                String errMsg;
                if (conn.getErrorStream() != null) {
                    ByteArrayOutputStream errOut = new ByteArrayOutputStream();
                    Client.copyStream(conn.getErrorStream(), errOut);
                    errMsg = errOut.toString();
                } else {
                    errMsg = conn.getResponseMessage();
                }
                throw new PdfcrowdError(errMsg, conn.getResponseCode());
            }
            InputStream rd = conn.getInputStream();
            Client.copyStream(rd, outStream);
            rd.close();
            wr.close();
        }
        catch (IOException e) {
            throw new PdfcrowdError(e);
        }
    }

    private ByteArrayOutputStream encodeMultipartPostData(String filename) {
        try {
            Vector<String> body = new Vector<String>();
            Iterator<String> it = this.fields.keySet().iterator();
            ByteArrayOutputStream retval = new ByteArrayOutputStream();
            while (it.hasNext()) {
                String key = it.next();
                String val = this.fields.get(key);
                if (val == null) continue;
                body.add("--" + MULTIPART_BOUNDARY);
                body.add(String.format("Content-Disposition: form-data; name=\"%s\"", key));
                body.add("");
                body.add(val);
            }
            body.add("--" + MULTIPART_BOUNDARY);
            body.add(String.format("Content-Disposition: form-data; name=\"src\"; filename=\"%s\"", filename));
            body.add("Content-Type: application/octet-stream");
            body.add("");
            body.add("");
            retval.write(Client.join(body, "\r\n").getBytes("UTF-8"));
            body.clear();
            Client.copyStream(new FileInputStream(filename), retval);
            body.add("");
            body.add("--" + MULTIPART_BOUNDARY);
            body.add("");
            retval.write(Client.join(body, "\r\n").getBytes("UTF-8"));
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw new PdfcrowdError(e);
        }
        catch (IOException e) {
            throw new PdfcrowdError(e);
        }
    }

    private byte[] encodePostData(String src) {
        Vector<String> body = new Vector<String>();
        Iterator<String> it = this.fields.keySet().iterator();
        try {
            if (src != null) {
                body.add(URLEncoder.encode("src", "UTF-8") + "=" + URLEncoder.encode(src, "UTF-8"));
            }
            while (it.hasNext()) {
                String key = it.next();
                String val = this.fields.get(key);
                if (val == null) continue;
                body.add(URLEncoder.encode(key.toString(), "UTF-8") + "=" + URLEncoder.encode(val.toString(), "UTF-8"));
            }
            return Client.join(body, "&").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PdfcrowdError(e);
        }
    }
}

