/*
 * Decompiled with CFR 0.152.
 */
package com.pdfcrowd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

class Base64Utils {
    private static final byte EQUALS_SIGN = 61;
    private static final String PREFERRED_ENCODING = "US-ASCII";
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    private Base64Utils() {
    }

    private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = _STANDARD_ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = _STANDARD_ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = _STANDARD_ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = _STANDARD_ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = _STANDARD_ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = _STANDARD_ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = _STANDARD_ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = _STANDARD_ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = _STANDARD_ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    public static String encodeBytes(byte[] source) {
        String encoded;
        block4: {
            if (source == null) {
                throw new NullPointerException("Cannot serialize a null array.");
            }
            encoded = null;
            try {
                encoded = Base64Utils.encodeBytes(source, source.length);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        assert (encoded != null);
        return encoded;
    }

    private static String encodeBytes(byte[] source, int len) throws IOException {
        byte[] encoded = Base64Utils.encodeBytesToBytes(source, len);
        try {
            return new String(encoded, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(encoded);
        }
    }

    private static byte[] encodeBytesToBytes(byte[] source, int len) throws IOException {
        int encLen = len / 3 * 4 + (len % 3 > 0 ? 4 : 0);
        byte[] outBuff = new byte[encLen];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64Utils.encode3to4(source, d, 3, outBuff, e);
            lineLength += 4;
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64Utils.encode3to4(source, d, len - d, outBuff, e);
            e += 4;
        }
        if (e <= outBuff.length - 1) {
            byte[] finalOut = new byte[e];
            System.arraycopy(outBuff, 0, finalOut, 0, e);
            return finalOut;
        }
        return outBuff;
    }
}

