/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.discovery.shared.dns.DnsService;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsClusterResolver
implements ClusterResolver<EurekaEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(DnsClusterResolver.class);
    private final List<EurekaEndpoint> eurekaEndpoints;
    private final String region;

    public DnsClusterResolver(DnsService dnsService, String region, String rootClusterDNS, int port, boolean isSecure, String relativeUri) {
        this.region = region;
        List<String> addresses = dnsService.resolveARecord(rootClusterDNS);
        this.eurekaEndpoints = addresses == null ? Collections.singletonList(new DefaultEndpoint(rootClusterDNS, port, isSecure, relativeUri)) : DefaultEndpoint.createForServerList(addresses, port, isSecure, relativeUri);
        logger.debug("Resolved {} to {}", (Object)rootClusterDNS, this.eurekaEndpoints);
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public List<EurekaEndpoint> getClusterEndpoints() {
        return this.eurekaEndpoints;
    }
}

