/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.ClusterResolverFactory;
import com.netflix.discovery.shared.resolver.ReloadingClusterResolver;
import com.netflix.discovery.shared.resolver.StaticClusterResolver;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import com.netflix.discovery.shared.resolver.aws.DnsTxtRecordClusterResolver;
import com.netflix.discovery.shared.resolver.aws.ZoneAffinityClusterResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyClusterResolver
implements ClusterResolver<AwsEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(LegacyClusterResolver.class);
    private final ClusterResolver<AwsEndpoint> delegate;

    public LegacyClusterResolver(EurekaClientConfig clientConfig, String myZone) {
        this.delegate = new ReloadingClusterResolver<AwsEndpoint>(new LegacyClusterResolverFactory(clientConfig, myZone), clientConfig.getEurekaServiceUrlPollIntervalSeconds() * 1000);
    }

    @Override
    public String getRegion() {
        return this.delegate.getRegion();
    }

    @Override
    public List<AwsEndpoint> getClusterEndpoints() {
        return this.delegate.getClusterEndpoints();
    }

    static class LegacyClusterResolverFactory
    implements ClusterResolverFactory<AwsEndpoint> {
        private final EurekaClientConfig clientConfig;
        private final String myRegion;
        private final String myZone;

        LegacyClusterResolverFactory(EurekaClientConfig clientConfig, String myZone) {
            this.clientConfig = clientConfig;
            this.myRegion = clientConfig.getRegion();
            this.myZone = myZone;
        }

        @Override
        public ClusterResolver<AwsEndpoint> createClusterResolver() {
            ClusterResolver<AwsEndpoint> newResolver;
            if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
                String discoveryDnsName = "txt." + this.myRegion + '.' + this.clientConfig.getEurekaServerDNSName();
                newResolver = new DnsTxtRecordClusterResolver(this.myRegion, discoveryDnsName, true, Integer.parseInt(this.clientConfig.getEurekaServerPort()), false, this.clientConfig.getEurekaServerURLContext());
                newResolver = new ZoneAffinityClusterResolver(newResolver, this.myZone, this.clientConfig.shouldPreferSameZoneEureka());
            } else {
                newResolver = new StaticClusterResolver<AwsEndpoint>(this.myRegion, this.createEurekaEndpointsFromConfig());
            }
            return newResolver;
        }

        private List<AwsEndpoint> createEurekaEndpointsFromConfig() {
            List<String> serviceUrls = EndpointUtils.getServiceUrlsFromConfig(this.clientConfig, this.myZone, this.clientConfig.shouldPreferSameZoneEureka());
            ArrayList<AwsEndpoint> endpoints = new ArrayList<AwsEndpoint>(serviceUrls.size());
            for (String serviceUrl : serviceUrls) {
                try {
                    URI serviceURI = new URI(serviceUrl);
                    endpoints.add(new AwsEndpoint(serviceURI.getHost(), serviceURI.getPort(), "https".equalsIgnoreCase(serviceURI.getSchemeSpecificPart()), serviceURI.getPath(), this.myRegion, this.myZone));
                }
                catch (URISyntaxException ignore) {
                    logger.warn("Invalid eureka server URI: ; removing from the server pool", (Object)serviceUrl);
                }
            }
            return endpoints;
        }
    }
}

