/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.kit.EnumKit;

public class DebugInterceptor
implements Interceptor {
    List<String> includes = null;

    public DebugInterceptor() {
    }

    public DebugInterceptor(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public void before(InterceptorContext ctx) {
        String sqlId = ctx.getSqlId();
        if (this.isDebugEanble(sqlId)) {
            ctx.put("debug.time", System.currentTimeMillis());
        }
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator", "\n");
        sb.append("\u250f\u2501\u2501\u2501\u2501\u2501 Debug [").append(this.getSqlId(this.formatSql(sqlId))).append("] \u2501\u2501\u2501").append(lineSeparator).append("\u2523 SQL\uff1a\t " + this.formatSql(ctx.getSql()) + lineSeparator).append("\u2523 \u53c2\u6570\uff1a\t " + this.formatParas(ctx.getParas())).append(lineSeparator);
        RuntimeException ex = new RuntimeException();
        StackTraceElement[] traces = ex.getStackTrace();
        boolean found = false;
        for (int i = 0; i < traces.length; ++i) {
            StackTraceElement tr = traces[i];
            if (found || tr.getClassName().indexOf("SQLManager") == -1) continue;
            found = true;
            int start = this.findLastSQLManager(i, traces);
            int index = this.findMapperJavaProxy(start, traces);
            StackTraceElement bussinessCode = null;
            bussinessCode = index == -1 ? traces[start] : traces[index + 2];
            String className = bussinessCode.getClassName();
            String mehodName = bussinessCode.getMethodName();
            int line = bussinessCode.getLineNumber();
            sb.append("\u2523 \u4f4d\u7f6e\uff1a\t " + className + "." + mehodName + "(" + bussinessCode.getFileName() + ":" + line + ")" + lineSeparator);
            break;
        }
        ctx.put("logs", sb);
    }

    protected int findMapperJavaProxy(int start, StackTraceElement[] traces) {
        for (int i = start; i < traces.length; ++i) {
            StackTraceElement el = traces[i];
            if (!el.getClassName().equals("org.beetl.sql.core.mapper.MapperJavaProxy")) continue;
            return i;
        }
        return -1;
    }

    protected int findLastSQLManager(int start, StackTraceElement[] traces) {
        for (int i = start; i < traces.length; ++i) {
            StackTraceElement el = traces[i];
            if (el.getClassName().equals("org.beetl.sql.core.SQLManager")) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void after(InterceptorContext ctx) {
        long time = System.currentTimeMillis();
        long start = (Long)ctx.get("debug.time");
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder sb = (StringBuilder)ctx.get("logs");
        sb.append("\u2523 \u65f6\u95f4\uff1a\t " + (time - start) + "ms").append(lineSeparator);
        if (ctx.isUpdate()) {
            sb.append("\u2523 \u66f4\u65b0\uff1a\t [");
            if (ctx.getResult().getClass().isArray()) {
                int[] ret = (int[])ctx.getResult();
                for (int i = 0; i < ret.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(ret[i]);
                }
            } else {
                sb.append(ctx.getResult());
            }
            sb.append("]").append(lineSeparator);
        } else if (ctx.getResult() instanceof Collection) {
            sb.append("\u2523 \u7ed3\u679c\uff1a\t [").append(((Collection)ctx.getResult()).size()).append("]").append(lineSeparator);
        } else {
            sb.append("\u2523 \u7ed3\u679c\uff1a\t [").append(ctx.getResult()).append("]").append(lineSeparator);
        }
        sb.append("\u2517\u2501\u2501\u2501\u2501\u2501 Debug [").append(this.getSqlId(this.formatSql(ctx.getSqlId()))).append("] \u2501\u2501\u2501").append(lineSeparator);
        this.println(sb.toString());
    }

    protected boolean isDebugEanble(String sqlId) {
        if (this.includes == null) {
            return true;
        }
        for (String id : this.includes) {
            if (!sqlId.startsWith(id)) continue;
            return true;
        }
        return false;
    }

    protected List<String> formatParas(List<SQLParameter> list) {
        ArrayList<String> data = new ArrayList<String>(list.size());
        for (SQLParameter para : list) {
            Object obj = para.value;
            if (obj == null) {
                data.add(null);
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 60) {
                    data.add(str.substring(0, 60) + "...(" + str.length() + ")");
                    continue;
                }
                data.add(str);
                continue;
            }
            if (obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                data.add(sdf.format((Date)obj));
                continue;
            }
            if (obj instanceof Enum) {
                Object value = EnumKit.getValueByEnum(obj);
                data.add(String.valueOf(value));
                continue;
            }
            data.add(obj.toString());
        }
        return data;
    }

    protected void println(String str) {
        System.out.println(str);
    }

    protected String getSqlId(String sqlId) {
        if (sqlId.length() > 50) {
            sqlId = sqlId.substring(0, 50);
            sqlId = sqlId + "...";
        }
        return sqlId;
    }

    @Override
    public void exception(InterceptorContext ctx, Exception ex) {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder sb = (StringBuilder)ctx.get("logs");
        sb.append("\u2517\u2501\u2501\u2501\u2501\u2501 Debug [ ERROR:").append(ex != null ? ex.getMessage() : "").append("] \u2501\u2501\u2501").append(lineSeparator);
        this.println(sb.toString());
    }

    protected String formatSql(String sql) {
        return sql.replaceAll("--.*", "").replaceAll("\\s+", " ");
    }
}

