/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.JavaType;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.EnumKit;
import org.beetl.sql.core.mapping.type.BigDecimalTypeHandler;
import org.beetl.sql.core.mapping.type.BooleanTypeHandler;
import org.beetl.sql.core.mapping.type.ByteArrayTypeHandler;
import org.beetl.sql.core.mapping.type.ByteTypeHandler;
import org.beetl.sql.core.mapping.type.CharArrayTypeHandler;
import org.beetl.sql.core.mapping.type.DateTypeHandler;
import org.beetl.sql.core.mapping.type.DefaultTypeHandler;
import org.beetl.sql.core.mapping.type.DoubleTypeHandler;
import org.beetl.sql.core.mapping.type.FloatTypeHandler;
import org.beetl.sql.core.mapping.type.IntegerTypeHandler;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.LongTypeHandler;
import org.beetl.sql.core.mapping.type.ShortTypeHandler;
import org.beetl.sql.core.mapping.type.SqlDateTypeHandler;
import org.beetl.sql.core.mapping.type.SqlXMLTypeHandler;
import org.beetl.sql.core.mapping.type.StringTypeHandler;
import org.beetl.sql.core.mapping.type.TimeTypeHandler;
import org.beetl.sql.core.mapping.type.TimestampTypeHandler;
import org.beetl.sql.core.mapping.type.TypeParameter;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    protected NameConversion nc = null;
    protected SQLManager sm;
    protected String dbName;
    protected int dbType;
    protected Map<Class, JavaSqlTypeHandler> handlers = new HashMap<Class, JavaSqlTypeHandler>();
    protected JavaSqlTypeHandler defaultHandler = new DefaultTypeHandler();
    static BigDecimalTypeHandler bigDecimalHandler = new BigDecimalTypeHandler();
    static BooleanTypeHandler booleanDecimalHandler = new BooleanTypeHandler();
    static ByteArrayTypeHandler byteArrayTypeHandler = new ByteArrayTypeHandler();
    static ByteTypeHandler byteTypeHandler = new ByteTypeHandler();
    static CharArrayTypeHandler charArrayTypeHandler = new CharArrayTypeHandler();
    static DateTypeHandler dateTypeHandler = new DateTypeHandler();
    static DoubleTypeHandler doubleTypeHandler = new DoubleTypeHandler();
    static FloatTypeHandler floatTypeHandler = new FloatTypeHandler();
    static IntegerTypeHandler integerTypeHandler = new IntegerTypeHandler();
    static LongTypeHandler longTypeHandler = new LongTypeHandler();
    static ShortTypeHandler shortTypeHandler = new ShortTypeHandler();
    static SqlDateTypeHandler sqlDateTypeHandler = new SqlDateTypeHandler();
    static SqlXMLTypeHandler sqlXMLTypeHandler = new SqlXMLTypeHandler();
    static StringTypeHandler stringTypeHandler = new StringTypeHandler();
    static TimestampTypeHandler timestampTypeHandler = new TimestampTypeHandler();
    static TimeTypeHandler timeTypeHandler = new TimeTypeHandler();

    public BeanProcessor(SQLManager sm) {
        this.nc = sm.getNc();
        this.sm = sm;
        this.dbName = sm.getDbStyle().getName();
        this.dbType = sm.getDbStyle().getDBType();
        this.initHandlers();
    }

    private void initHandlers() {
        this.handlers.put(BigDecimal.class, bigDecimalHandler);
        this.handlers.put(Boolean.class, booleanDecimalHandler);
        this.handlers.put(byte[].class, byteArrayTypeHandler);
        this.handlers.put(Byte.TYPE, byteTypeHandler);
        this.handlers.put(Byte.class, byteTypeHandler);
        this.handlers.put(char[].class, charArrayTypeHandler);
        this.handlers.put(java.util.Date.class, dateTypeHandler);
        this.handlers.put(Double.class, doubleTypeHandler);
        this.handlers.put(Double.TYPE, doubleTypeHandler);
        this.handlers.put(Float.class, floatTypeHandler);
        this.handlers.put(Float.TYPE, floatTypeHandler);
        this.handlers.put(Integer.class, integerTypeHandler);
        this.handlers.put(Integer.TYPE, integerTypeHandler);
        this.handlers.put(Long.class, longTypeHandler);
        this.handlers.put(Long.TYPE, longTypeHandler);
        this.handlers.put(Short.class, shortTypeHandler);
        this.handlers.put(Short.TYPE, shortTypeHandler);
        this.handlers.put(Date.class, sqlDateTypeHandler);
        this.handlers.put(SQLXML.class, sqlXMLTypeHandler);
        this.handlers.put(String.class, stringTypeHandler);
        this.handlers.put(Timestamp.class, timestampTypeHandler);
        this.handlers.put(Time.class, timeTypeHandler);
    }

    public <T> T toBean(String sqlId, ResultSet rs, Class<T> type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(type, rsmd, props);
        return this.createBean(sqlId, rs, type, props, columnToProperty);
    }

    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        return this.toBean(null, rs, type);
    }

    public <T> List<T> toBeanList(String sqlId, ResultSet rs, Class<T> type) throws SQLException {
        if (!rs.next()) {
            return new ArrayList(0);
        }
        ArrayList<T> results = new ArrayList<T>();
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(type, rsmd, props);
        do {
            results.add(this.createBean(sqlId, rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    public Map<String, Object> toMap(String sqlId, Class<?> c, ResultSet rs) throws SQLException {
        Map result = BeanKit.getMapIns(c);
        if (c == null) {
            throw new SQLException("\u4e0d\u80fd\u6620\u5c04\u6210Map:" + c);
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        TypeParameter tp = new TypeParameter(sqlId, this.dbName, null, rs, rsmd, 0);
        for (int i = 1; i <= cols; ++i) {
            int colType;
            Class<?> classType;
            JavaSqlTypeHandler handler;
            String columnName = rsmd.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            if ((handler = this.handlers.get(classType = JavaType.jdbcJavaTypes.get(colType = rsmd.getColumnType(i)))) == null) {
                handler = this.defaultHandler;
            }
            tp.setIndex(i);
            tp.setTarget(classType);
            Object value = handler.getValue(tp);
            result.put(this.nc.getPropertyName(c, columnName), value);
        }
        return result;
    }

    public Object toBaseType(String sqlId, Class<?> c, ResultSet rs) throws SQLException {
        TypeParameter tp = new TypeParameter(sqlId, this.dbName, c, rs, rs.getMetaData(), 1);
        int count = tp.getMeta().getColumnCount();
        if (count != 1) {
            throw new SQLException("Beetlsql\u67e5\u8be2\u671f\u671b\u8fd4\u56de\u4e00\u5217\uff0c\u8fd4\u56de\u7c7b\u578b\u4e3a" + c + " \u4f46\u8fd4\u56de\u4e86" + count + "\u5217\uff0c" + sqlId);
        }
        JavaSqlTypeHandler handler = this.handlers.get(c);
        if (handler == null) {
            handler = this.defaultHandler;
        }
        return handler.getValue(tp);
    }

    protected <T> T createBean(String sqlId, ResultSet rs, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        T bean = this.newInstance(type);
        ResultSetMetaData meta = rs.getMetaData();
        TypeParameter tp = new TypeParameter(sqlId, this.dbName, type, rs, meta, 1);
        for (int i = 1; i < columnToProperty.length; ++i) {
            tp.setIndex(i);
            if (columnToProperty[i] == -1) {
                Object value;
                String key = rs.getMetaData().getColumnLabel(i);
                if (key.equals("beetl_rn")) continue;
                if (bean instanceof Tail) {
                    Tail bean2 = (Tail)bean;
                    value = this.noMappingValue(tp);
                    key = this.nc.getPropertyName(type, key);
                    bean2.set(key, value);
                    continue;
                }
                Method m = BeanKit.getTailMethod(type);
                if (m == null) continue;
                value = this.noMappingValue(tp);
                key = this.nc.getPropertyName(type, key);
                try {
                    m.invoke(bean, key, value);
                    continue;
                }
                catch (Exception ex) {
                    throw new BeetlSQLException(13, ex);
                }
            }
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            tp.setTarget(propType);
            JavaSqlTypeHandler handler = this.handlers.get(propType);
            if (handler == null) {
                handler = this.defaultHandler;
            }
            Object value = handler.getValue(tp);
            this.callSetter(bean, prop, value, propType);
        }
        return bean;
    }

    protected Object noMappingValue(TypeParameter tp) throws SQLException {
        JavaSqlTypeHandler handler;
        Object value = null;
        Class<?> expectedType = JavaType.jdbcJavaTypes.get(tp.getColumnType());
        value = expectedType != null ? ((handler = this.handlers.get(expectedType)) == null ? tp.getObject() : handler.getValue(tp)) : tp.getObject();
        return value;
    }

    protected void callSetter(Object target, PropertyDescriptor prop, Object value, Class type) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        if (type.isEnum()) {
            if (value == null) {
                return;
            }
            Enum numValue = EnumKit.getEnumByValue(type, value);
            if (numValue == null) {
                throw new SQLException("Cannot set ENUM " + prop.getName() + ": Convert to NULL for value " + value);
            }
            value = numValue;
        }
        try {
            setter.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    protected <T> T newInstance(Class<T> c) throws SQLException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new BeetlSQLException(9, e);
        }
        catch (IllegalAccessException e) {
            throw new BeetlSQLException(9, e);
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        try {
            return BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
    }

    protected int[] mapColumnsToProperties(Class<?> c, ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            String expectedProperty = this.nc.getPropertyName(c, columnName);
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equalsIgnoreCase(expectedProperty)) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }

    public void setPreparedStatementPara(String sqlId, PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        for (int i = 0; i < objs.size(); ++i) {
            int jdbcType;
            SQLParameter para = objs.get(i);
            Object o = para.value;
            if (o == null) {
                ps.setObject(i + 1, o);
                continue;
            }
            Class<?> c = o.getClass();
            if ((this.dbType == 2 || this.dbType == 3 || this.dbType == 6 || this.dbType == 4) && c == java.util.Date.class) {
                o = new Timestamp(((java.util.Date)o).getTime());
            }
            if (Enum.class.isAssignableFrom(c)) {
                o = EnumKit.getValueByEnum(o);
            }
            if (c == char[].class) {
                o = new String((char[])o);
            }
            if ((jdbcType = para.getJdbcType()) == 0) {
                ps.setObject(i + 1, o);
                continue;
            }
            throw new UnsupportedOperationException(jdbcType + ",\u9ed8\u8ba4\u5904\u7406\u5668\u5e76\u672a\u5904\u7406\u6b64jdbc\u7c7b\u578b");
        }
    }
}

