/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.Serializable;
import java.util.List;

public class PageQuery<T>
implements Serializable {
    private static final long serialVersionUID = -7523359884334787081L;
    public static String pageFlag = "_page";
    public static Object pageObj = new Object();
    protected List<T> list;
    protected Object paras;
    protected String orderBy;
    protected long pageNumber;
    public static long DEFAULT_PAGE_SIZE = 20L;
    protected long pageSize = DEFAULT_PAGE_SIZE;
    protected long totalPage;
    protected long totalRow = -1L;

    public PageQuery() {
        this(1L, null);
    }

    public PageQuery(long pageNumber) {
        this(pageNumber, null);
    }

    public PageQuery(long pageNumber, long pageSize) {
        this(pageNumber, null);
        this.pageSize = pageSize;
    }

    public PageQuery(long pageNumber, Object paras) {
        this.pageNumber = pageNumber;
        this.paras = paras;
    }

    public PageQuery(long pageNumber, Object paras, String userDefinedOrderBy) {
        this.pageNumber = pageNumber;
        this.paras = paras;
        this.orderBy = userDefinedOrderBy;
    }

    public PageQuery(long pageNumber, Object paras, long totalRow) {
        this(pageNumber, paras);
        this.totalRow = totalRow;
    }

    public PageQuery(long pageNumber, Object paras, String userDefinedOrderBy, long totalRow) {
        this.pageNumber = pageNumber;
        this.paras = paras;
        this.orderBy = userDefinedOrderBy;
        this.totalRow = totalRow;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public PageQuery(long pageNumber, Object paras, long totalRow, long pageSize) {
        this(pageNumber, paras);
        this.totalRow = totalRow;
        this.pageSize = pageSize;
    }

    public List<T> getList() {
        return this.list;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public boolean isFirstPage() {
        return this.pageNumber == 1L;
    }

    public boolean isLastPage() {
        return this.pageNumber == this.totalPage;
    }

    public Object getParas() {
        return this.paras;
    }

    public void setParas(Object paras) {
        this.paras = paras;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setTotalRow(long totalRow) {
        this.totalRow = totalRow;
    }

    public void setList(List list) {
        this.list = list;
        this.calcTotalPage();
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    protected void calcTotalPage() {
        this.totalPage = this.totalRow == 0L ? 1L : (this.totalRow % this.pageSize == 0L ? this.totalRow / this.pageSize : this.totalRow / this.pageSize + 1L);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (int)(this.pageNumber ^ this.pageNumber >>> 32);
        result = 31 * result + (int)(this.pageSize ^ this.pageSize >>> 32);
        result = 31 * result + (this.paras == null ? 0 : this.paras.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageQuery other = (PageQuery)obj;
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        return !(this.paras == null ? other.paras != null : !this.paras.equals(other.paras));
    }
}

