/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;

public class TableDesc {
    private String name;
    private Set<String> idNames = new CaseInsensitiveOrderSet();
    private String remark = null;
    private Set<String> cols = new CaseInsensitiveOrderSet();
    private Map<Class, ClassDesc> classes = new LinkedHashMap<Class, ClassDesc>();
    private CaseInsensitiveHashMap<String, ColDesc> colsDetail = new CaseInsensitiveHashMap();
    private String schema;

    public TableDesc(String name, String remark) {
        this.name = name;
        this.remark = remark;
    }

    public boolean containCol(String col) {
        return this.cols.contains(col);
    }

    public String getExactCol(String col) {
        for (String str : this.cols) {
            if (!str.equalsIgnoreCase(col)) continue;
            return str;
        }
        throw new RuntimeException("call containCol first to ensure exist");
    }

    public void addCols(ColDesc col) {
        this.colsDetail.put(col.colName, (Object)col);
        this.cols.add(col.colName);
    }

    public ColDesc getColDesc(String name) {
        return (ColDesc)this.colsDetail.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getIdNames() {
        return this.idNames;
    }

    public void addIdName(String idName) {
        this.idNames.add(idName);
    }

    public Set<String> getCols() {
        return this.cols;
    }

    public String getRemark() {
        return this.remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDesc getClassDesc(Class c, NameConversion nc) {
        ClassDesc classDesc = this.classes.get(c);
        if (classDesc == null) {
            Map<Class, ClassDesc> map = this.classes;
            synchronized (map) {
                classDesc = this.classes.get(c);
                if (classDesc != null) {
                    return classDesc;
                }
                classDesc = new ClassDesc(c, this, nc);
                this.classes.put(c, classDesc);
            }
        }
        return classDesc;
    }

    public ClassDesc getClassDesc(NameConversion nc) {
        ClassDesc c = new ClassDesc(this, nc);
        return c;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

