/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;

public class H2Style
extends AbstractDBStyle {
    @Override
    public String getPageSQL(String sql) {
        return sql + this.getOrderBy() + " \nlimit " + this.HOLDER_START + "_pageOffset" + this.HOLDER_END + " , " + this.HOLDER_START + "_pageSize" + this.HOLDER_END;
    }

    @Override
    public String getPageSQLStatement(String sql, long offset, long pageSize) {
        int capacity = sql.length() + 23;
        StringBuilder builder = new StringBuilder(capacity);
        builder.append(" limit ").append(offset).append(" , ").append(pageSize);
        return builder.toString();
    }

    @Override
    public void initPagePara(Map<String, Object> param, long start, long size) {
        param.put("_pageOffset", start);
        param.put("_pageSize", size);
    }

    @Override
    public String getName() {
        return "h2";
    }

    public String getEscapeForKeyWord() {
        return "\"";
    }

    @Override
    public int getDBType() {
        return 7;
    }
}

