/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Transient;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.annotatoin.Table;
import org.beetl.sql.core.kit.StringKit;

public class JPAEntityHelper {
    private static final Map<Class<?>, EntityTable> entityTableMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityTable getEntityTable(Class<?> entityClass, NameConversion nc) {
        EntityTable entityTable = null;
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            entityTable = entityTableMap.get(entityClass);
            if (entityTable == null) {
                JPAEntityHelper.initEntityNameMap(entityClass, nc);
                entityTable = entityTableMap.get(entityClass);
            }
        }
        if (entityTable == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    private static synchronized void initEntityNameMap(Class<?> entityClass, NameConversion nc) {
        Object table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        EntityTable entityTable = new EntityTable();
        if (entityClass.isAnnotationPresent(javax.persistence.Table.class)) {
            table = entityClass.getAnnotation(javax.persistence.Table.class);
            if (StringKit.isNotBlank(table.name())) {
                entityTable.setTable((javax.persistence.Table)table);
            }
        } else if (entityClass.isAnnotationPresent(Table.class)) {
            table = entityClass.getAnnotation(Table.class);
            entityTable.setName(table.name());
        }
        if (StringKit.isBlank(entityTable.getName())) {
            entityTable.setName(nc != null ? nc.getTableName(entityClass) : entityClass.getSimpleName());
        }
        List<Field> fieldList = JPAEntityHelper.getAllField(entityClass, null);
        for (Field field : fieldList) {
            String propName = field.getName();
            Method method = null;
            try {
                PropertyDescriptor p = new PropertyDescriptor(field.getName(), entityClass);
                method = p.getReadMethod();
            }
            catch (IntrospectionException e) {
                Logger.getLogger(JPAEntityHelper.class.getName()).log(Level.SEVERE, null, e);
            }
            Column column = null;
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
            } else if (method != null && method.isAnnotationPresent(Column.class)) {
                column = method.getAnnotation(Column.class);
            }
            String columnName = null;
            if (column != null) {
                columnName = column.name();
            }
            if (StringKit.isBlank(columnName)) {
                String string = columnName = nc != null ? nc.getColName(propName) : propName;
            }
            if (field.isAnnotationPresent(Transient.class) || method != null && method.isAnnotationPresent(Transient.class)) {
                entityTable.addCol(propName, null);
                entityTable.addProp(columnName, null);
                continue;
            }
            entityTable.addCol(propName, columnName);
            entityTable.addProp(columnName, propName);
        }
        entityTableMap.put(entityClass, entityTable);
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!(superClass == null || superClass.equals(Object.class) || Map.class.isAssignableFrom(superClass) || Collection.class.isAssignableFrom(superClass))) {
            return JPAEntityHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }

    public static class EntityTable {
        private String name;
        private Map<String, String> colsMap = new HashMap<String, String>();
        private Map<String, String> propsMap = new HashMap<String, String>();

        protected void setTable(javax.persistence.Table table) {
            this.name = table.name();
            if (StringKit.isNotBlank(table.schema())) {
                this.name = table.schema() + "." + this.name;
            } else if (StringKit.isNotBlank(table.catalog())) {
                this.name = table.catalog() + "." + this.name;
            }
        }

        protected void addProp(String col, String prop) {
            this.propsMap.put(col, prop);
        }

        protected void addCol(String prop, String col) {
            this.colsMap.put(prop, col);
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String getProp(String col) {
            return this.propsMap.get(col);
        }

        public String getCol(String prop) {
            return this.colsMap.get(prop);
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityTable other = (EntityTable)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

