/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.DefaultSQLIdNameConversion;
import org.beetl.sql.core.SQLIdNameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.kit.MDParser;

public class ClasspathLoader
implements SQLLoader {
    protected String sqlRoot = null;
    protected String lineSeparator = System.getProperty("line.separator", "\n");
    protected Map<String, SQLSource> sqlSourceMap = new ConcurrentHashMap<String, SQLSource>();
    protected Map<String, Integer> sqlSourceVersion = new ConcurrentHashMap<String, Integer>();
    protected DBStyle dbs = null;
    protected boolean autoCheck = true;
    protected String charset = null;
    protected SQLIdNameConversion sqlIdNameConversion = new DefaultSQLIdNameConversion();

    public ClasspathLoader() {
        this("/sql");
    }

    public ClasspathLoader(String root) {
        this(root, new MySqlStyle());
    }

    public ClasspathLoader(String root, DBStyle dbs) {
        this.sqlRoot = root;
        this.dbs = dbs;
    }

    @Override
    public SQLSource getSQL(String id) {
        SQLSource ss = this.tryLoadSQL(id);
        if (ss == null) {
            throw new BeetlSQLException(2, "\u672a\u80fd\u627e\u5230" + id + "\u5bf9\u5e94\u7684sql");
        }
        return ss;
    }

    private SQLSource tryLoadSQL(String id) {
        SQLSource ss = this.sqlSourceMap.get(id);
        boolean hasLoad = false;
        if (ss == null) {
            this.loadSql(id);
            hasLoad = true;
        }
        if (!hasLoad && this.autoCheck && this.isModified(id)) {
            this.loadSql(id);
        }
        ss = this.sqlSourceMap.get(id);
        return ss;
    }

    @Override
    public boolean isModified(String id) {
        String sqlName;
        int index = id.indexOf(46);
        if (index != -1 && (sqlName = id.substring(index)).startsWith("._gen")) {
            return false;
        }
        InputStream is = this.getDBRootFile(id);
        if (is == null) {
            is = this.getRootFile(id);
        }
        if (is != null) {
            Integer lastModify = is.hashCode();
            Integer oldVersion = this.sqlSourceVersion.get(id);
            if (oldVersion != null && oldVersion.equals(lastModify)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean exist(String id) {
        return this.tryLoadSQL(id) != null;
    }

    @Override
    public void addGenSQL(String id, SQLSource source) {
        this.sqlSourceVersion.put(id, 0);
        this.sqlSourceMap.put(id, source);
    }

    private boolean loadSql(String id) {
        InputStream ins = this.getRootFile(id);
        boolean rootResult = this.readSqlFile(id, ins);
        ins = this.getDBRootFile(id);
        boolean dbResult = this.readSqlFile(id, ins);
        if (rootResult || dbResult) {
            return true;
        }
        String modelName = id.substring(0, id.lastIndexOf("."));
        String path = modelName.replace('.', '/');
        String filePath0 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".md";
        String filePath2 = this.sqlRoot + "/" + path + ".sql";
        String filePath3 = this.sqlRoot + "/" + path + ".md";
        throw new BeetlSQLException(2, "\u5728 " + filePath0 + " \u548c " + filePath1 + " \u548c " + filePath2 + " \u548c " + filePath3 + " \u548c " + " \u672a\u627e\u5230[id=" + id + "]\u76f8\u5173\u7684SQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSqlFile(String id, InputStream ins) {
        String modelName = id.substring(0, id.lastIndexOf(".") + 1);
        if (ins == null) {
            return false;
        }
        Integer lastModified = ins.hashCode();
        this.sqlSourceVersion.put(id, lastModified);
        LinkedList list = new LinkedList();
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new InputStreamReader(ins, this.charset));
            MDParser parser = new MDParser(modelName, bf);
            SQLSource source = null;
            while ((source = parser.next()) != null) {
                this.sqlSourceMap.put(source.getId(), source);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private void buildSql(LinkedList<String> list, StringBuilder sql) {
        while (!list.isEmpty()) {
            String s = list.pollFirst();
            if (s.startsWith("```") || s.startsWith("~~~")) continue;
            sql.append(s + this.lineSeparator);
        }
    }

    public Map<String, SQLSource> getSqlSourceMap() {
        return this.sqlSourceMap;
    }

    public String getSqlRoot() {
        return this.sqlRoot;
    }

    public void setSqlRoot(String sqlRoot) {
        this.sqlRoot = sqlRoot;
    }

    private InputStream getRootFile(String id) {
        String path = this.sqlIdNameConversion.getPath(id);
        String filePath0 = this.sqlRoot + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + path + ".md";
        InputStream is = this.getFile(filePath0, id);
        if (is == null && (is = this.getFile(filePath1, id)) == null) {
            return null;
        }
        return is;
    }

    private InputStream getDBRootFile(String id) {
        String path = this.sqlIdNameConversion.getPath(id);
        String filePath0 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".md";
        InputStream is = this.getFile(filePath0, id);
        if (is == null && (is = this.getFile(filePath1, id)) == null) {
            return null;
        }
        return is;
    }

    private InputStream getFile(String filePath, String id) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        if (loader != null) {
            is = loader.getResourceAsStream(filePath);
            if (is != null) {
                return is;
            }
            is = this.getClass().getResourceAsStream(filePath);
            return is;
        }
        is = this.getClass().getResourceAsStream(filePath);
        return is;
    }

    @Override
    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    @Override
    public void setAutoCheck(boolean check) {
        this.autoCheck = check;
    }

    @Override
    public SQLSource getGenSQL(String id) {
        return this.sqlSourceMap.get(id);
    }

    public DBStyle getDbs() {
        return this.dbs;
    }

    public void setDbs(DBStyle dbs) {
        this.dbs = dbs;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toString() {
        return this.sqlRoot;
    }

    @Override
    public void setSQLIdNameConversion(SQLIdNameConversion sqlIdNc) {
        this.sqlIdNameConversion = sqlIdNc;
    }

    @Override
    public void setDbStyle(DBStyle dbStyle) {
        this.dbs = dbStyle;
    }
}

