/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.bean.message;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.builder.outxml.ImageBuilder;
import me.chanjar.weixin.mp.builder.outxml.MusicBuilder;
import me.chanjar.weixin.mp.builder.outxml.NewsBuilder;
import me.chanjar.weixin.mp.builder.outxml.TextBuilder;
import me.chanjar.weixin.mp.builder.outxml.TransferCustomerServiceBuilder;
import me.chanjar.weixin.mp.builder.outxml.VideoBuilder;
import me.chanjar.weixin.mp.builder.outxml.VoiceBuilder;
import me.chanjar.weixin.mp.util.crypto.WxMpCryptUtil;
import me.chanjar.weixin.mp.util.xml.XStreamTransformer;

@XStreamAlias(value="xml")
public abstract class WxMpXmlOutMessage
implements Serializable {
    private static final long serialVersionUID = -381382011286216263L;
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    protected String toUserName;
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    protected String fromUserName;
    @XStreamAlias(value="CreateTime")
    protected Long createTime;
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    protected String msgType;

    public String getToUserName() {
        return this.toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toXml() {
        return XStreamTransformer.toXml(this.getClass(), this);
    }

    public String toEncryptedXml(WxMpConfigStorage wxMpConfigStorage) {
        String plainXml = this.toXml();
        WxMpCryptUtil pc = new WxMpCryptUtil(wxMpConfigStorage);
        return pc.encrypt(plainXml);
    }

    public static TextBuilder TEXT() {
        return new TextBuilder();
    }

    public static ImageBuilder IMAGE() {
        return new ImageBuilder();
    }

    public static VoiceBuilder VOICE() {
        return new VoiceBuilder();
    }

    public static VideoBuilder VIDEO() {
        return new VideoBuilder();
    }

    public static MusicBuilder MUSIC() {
        return new MusicBuilder();
    }

    public static NewsBuilder NEWS() {
        return new NewsBuilder();
    }

    public static TransferCustomerServiceBuilder TRANSFER_CUSTOMER_SERVICE() {
        return new TransferCustomerServiceBuilder();
    }
}

