/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.CustomSplitConverter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;

public class HudiRealtimeSplitConverter
implements CustomSplitConverter {
    public static final String HUDI_DELTA_FILEPATHS_KEY = "hudi_delta_filepaths";
    public static final String HUDI_BASEPATH_KEY = "hudi_basepath";
    public static final String HUDI_MAX_COMMIT_TIME_KEY = "hudi_max_commit_time";

    @Override
    public Optional<Map<String, String>> extractCustomSplitInfo(FileSplit split) {
        if (split instanceof HoodieRealtimeFileSplit) {
            HoodieRealtimeFileSplit hudiSplit = (HoodieRealtimeFileSplit)split;
            ImmutableMap customSplitInfo = ImmutableMap.builder().put((Object)"custom_split_class", (Object)HoodieRealtimeFileSplit.class.getName()).put((Object)HUDI_DELTA_FILEPATHS_KEY, (Object)String.join((CharSequence)",", hudiSplit.getDeltaLogPaths())).put((Object)HUDI_BASEPATH_KEY, (Object)hudiSplit.getBasePath()).put((Object)HUDI_MAX_COMMIT_TIME_KEY, (Object)hudiSplit.getMaxCommitTime()).build();
            return Optional.of(customSplitInfo);
        }
        return Optional.empty();
    }

    @Override
    public Optional<FileSplit> recreateFileSplitWithCustomInfo(FileSplit split, Map<String, String> customSplitInfo) throws IOException {
        String customSplitClass = customSplitInfo.get("custom_split_class");
        if (HoodieRealtimeFileSplit.class.getName().equals(customSplitClass)) {
            Objects.requireNonNull(customSplitInfo.get(HUDI_DELTA_FILEPATHS_KEY), "HUDI_DELTA_FILEPATHS_KEY is missing");
            List<String> deltaLogPaths = Arrays.asList(customSplitInfo.get(HUDI_DELTA_FILEPATHS_KEY).split(","));
            List deltaLogFiles = deltaLogPaths.stream().map(p -> new HoodieLogFile(new Path(p))).collect(Collectors.toList());
            return Optional.of(new HoodieRealtimeFileSplit(split, Objects.requireNonNull(customSplitInfo.get(HUDI_BASEPATH_KEY), "HUDI_BASEPATH_KEY is missing"), deltaLogFiles, Objects.requireNonNull(customSplitInfo.get(HUDI_MAX_COMMIT_TIME_KEY), "HUDI_MAX_COMMIT_TIME_KEY is missing"), Option.empty()));
        }
        return Optional.empty();
    }
}

