/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class AggregatedOrcPageSource
implements ConnectorPageSource {
    private final List<HiveColumnHandle> columnHandles;
    private final Footer footer;
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private static final int batchSize = 1;
    private boolean completed;
    private long readTimeNanos;
    private long completedBytes;

    public AggregatedOrcPageSource(List<HiveColumnHandle> columnHandles, Footer footer, TypeManager typeManager, StandardFunctionResolution functionResolution) {
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.footer = Objects.requireNonNull(footer, "footer is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.completed;
    }

    public Page getNextPage() {
        if (this.completed) {
            return null;
        }
        long start = System.nanoTime();
        Block[] blocks = new Block[this.columnHandles.size()];
        for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
            HiveColumnHandle columnHandle = this.columnHandles.get(fieldId);
            AggregationNode.Aggregation aggregation = columnHandle.getPartialAggregation().get();
            int columnIndex = columnHandle.getHiveColumnIndex();
            Type type = this.typeManager.getType(columnHandle.getTypeSignature());
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 1, 0);
            FunctionHandle functionHandle = aggregation.getFunctionHandle();
            if (this.functionResolution.isCountFunction(functionHandle)) {
                if (aggregation.getArguments().isEmpty()) {
                    blockBuilder = blockBuilder.writeLong(this.footer.getNumberOfRows());
                } else {
                    this.writeNonNullCount(columnIndex, blockBuilder);
                }
                this.completedBytes += (long)IntegerType.INTEGER.getFixedSize();
            } else if (this.functionResolution.isMaxFunction(functionHandle)) {
                this.writeMinMax(columnIndex, type, columnHandle.getHiveType(), blockBuilder, false);
            } else if (this.functionResolution.isMinFunction(functionHandle)) {
                this.writeMinMax(columnIndex, type, columnHandle.getHiveType(), blockBuilder, true);
            } else {
                throw new UnsupportedOperationException(aggregation.getFunctionHandle().toString() + " is not supported");
            }
            blocks[fieldId] = blockBuilder.build();
        }
        this.completed = true;
        this.readTimeNanos += System.nanoTime() - start;
        return new Page(1, blocks);
    }

    private void writeMinMax(int columnIndex, Type type, HiveType hiveType, BlockBuilder blockBuilder, boolean isMin) {
        ColumnStatistics columnStatistics = (ColumnStatistics)this.footer.getFileStats().get(columnIndex + 1);
        OrcType orcType = (OrcType)this.footer.getTypes().get(columnIndex + 1);
        if (type instanceof FixedWidthType) {
            this.completedBytes += (long)((FixedWidthType)type).getFixedSize();
        }
        String orcNoMinMaxMessage = "No min/max found for orc file. Set session property hive.pushdown_partial_aggregations_into_scan=false and execute query again";
        switch (orcType.getOrcTypeKind()) {
            case SHORT: 
            case INT: 
            case LONG: {
                Long value;
                Long l = value = isMin ? columnStatistics.getIntegerStatistics().getMin() : columnStatistics.getIntegerStatistics().getMax();
                if (value == null) {
                    throw new UnsupportedOperationException(orcNoMinMaxMessage);
                }
                blockBuilder.writeLong(value.longValue());
                break;
            }
            case TIMESTAMP: 
            case DATE: {
                Integer value;
                Integer n = value = isMin ? columnStatistics.getDateStatistics().getMin() : columnStatistics.getDateStatistics().getMax();
                if (value == null) {
                    throw new UnsupportedOperationException(orcNoMinMaxMessage);
                }
                blockBuilder.writeLong(Long.valueOf(value.intValue()).longValue());
                break;
            }
            case VARCHAR: 
            case CHAR: 
            case STRING: {
                Slice value;
                Slice slice = value = isMin ? columnStatistics.getStringStatistics().getMin() : columnStatistics.getStringStatistics().getMax();
                if (value == null) {
                    throw new UnsupportedOperationException(orcNoMinMaxMessage);
                }
                blockBuilder.writeBytes(value, 0, value.length()).closeEntry();
                this.completedBytes += (long)value.length();
                break;
            }
            case FLOAT: {
                Double value;
                Double d = value = isMin ? columnStatistics.getDoubleStatistics().getMin() : columnStatistics.getDoubleStatistics().getMax();
                if (value == null) {
                    throw new UnsupportedOperationException(orcNoMinMaxMessage);
                }
                blockBuilder.writeLong((long)Float.floatToRawIntBits(value.floatValue()));
                break;
            }
            case DOUBLE: {
                Double value;
                Double d = value = isMin ? columnStatistics.getDoubleStatistics().getMin() : columnStatistics.getDoubleStatistics().getMax();
                if (value == null) {
                    throw new UnsupportedOperationException(orcNoMinMaxMessage);
                }
                type.writeDouble(blockBuilder, value.doubleValue());
                break;
            }
            case DECIMAL: {
                BigDecimal value;
                BigDecimal bigDecimal = value = isMin ? columnStatistics.getDecimalStatistics().getMin() : columnStatistics.getDecimalStatistics().getMax();
                if (value == null) {
                    throw new UnsupportedOperationException(orcNoMinMaxMessage);
                }
                Type definedType = hiveType.getType(this.typeManager);
                if (Decimals.isShortDecimal((Type)definedType)) {
                    blockBuilder.writeLong(value.unscaledValue().longValue());
                    break;
                }
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)value.unscaledValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + orcType.getOrcTypeKind());
            }
        }
    }

    private void writeNonNullCount(int columnIndex, BlockBuilder blockBuilder) {
        ColumnStatistics columnStatistics = (ColumnStatistics)this.footer.getFileStats().get(columnIndex + 1);
        if (!columnStatistics.hasNumberOfValues()) {
            throw new UnsupportedOperationException("Number of values not set for orc file. Set session property hive.pushdown_partial_aggregations_into_scan=false and execute query again");
        }
        blockBuilder.writeLong(columnStatistics.getNumberOfValues());
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

