/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.gcs;

import com.facebook.presto.hive.gcs.GcsAccessTokenProvider;
import com.facebook.presto.hive.gcs.GcsConfigurationInitializer;
import com.facebook.presto.hive.gcs.HiveGcsConfig;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class HiveGcsConfigurationInitializer
implements GcsConfigurationInitializer {
    private final boolean useGcsAccessToken;
    private final String jsonKeyFilePath;

    @Inject
    public HiveGcsConfigurationInitializer(HiveGcsConfig config) {
        this.useGcsAccessToken = config.isUseGcsAccessToken();
        this.jsonKeyFilePath = config.getJsonKeyFilePath();
    }

    @Override
    public void updateConfiguration(Configuration config) {
        config.set("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        if (this.useGcsAccessToken) {
            config.set(GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_ENABLE.getKey(), "false");
            config.set("fs.gs.auth.access.token.provider.impl", GcsAccessTokenProvider.class.getName());
        } else if (this.jsonKeyFilePath != null) {
            config.set(GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_ENABLE.getKey(), "true");
            config.set("fs.gs.auth.service.account.json.keyfile", this.jsonKeyFilePath);
        }
    }
}

