/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SubfieldExtractor {
    private final StandardFunctionResolution functionResolution;
    private final ExpressionOptimizer expressionOptimizer;
    private final ConnectorSession connectorSession;

    public SubfieldExtractor(StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.expressionOptimizer = Objects.requireNonNull(expressionOptimizer, "expressionOptimizer is null");
        this.connectorSession = Objects.requireNonNull(connectorSession, "connectorSession is null");
    }

    public DomainTranslator.ColumnExtractor<Subfield> toColumnExtractor() {
        return (expression, domain) -> {
            Type type = expression.getType();
            if (SubfieldExtractor.isComplexType(type) && !domain.isOnlyNull() && (!domain.getValues().isAll() || domain.isNullAllowed())) {
                return Optional.empty();
            }
            Optional<Subfield> subfield = this.extract(expression);
            if (SubfieldExtractor.hasSubscripts(subfield)) {
                if (HiveSessionProperties.isRangeFiltersOnSubscriptsEnabled(this.connectorSession)) {
                    return subfield;
                }
                return Optional.empty();
            }
            return subfield;
        };
    }

    private static boolean isComplexType(Type type) {
        return type instanceof ArrayType || type instanceof MapType || type instanceof RowType;
    }

    private static boolean hasSubscripts(Optional<Subfield> subfield) {
        return subfield.isPresent() && subfield.get().getPath().stream().anyMatch(Subfield.PathElement::isSubscript);
    }

    public Optional<Subfield> extract(RowExpression expression) {
        return SubfieldExtractor.toSubfield(expression, this.functionResolution, this.expressionOptimizer, this.connectorSession);
    }

    private static Optional<Subfield> toSubfield(RowExpression expression, StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession) {
        block5: {
            ArrayList<Object> elements = new ArrayList<Object>();
            while (true) {
                if (expression instanceof VariableReferenceExpression) {
                    Collections.reverse(elements);
                    return Optional.of(new Subfield(((VariableReferenceExpression)expression).getName(), Collections.unmodifiableList(elements)));
                }
                if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.DEREFERENCE) {
                    Optional fieldName;
                    Object index;
                    SpecialFormExpression dereferenceExpression = (SpecialFormExpression)expression;
                    RowExpression base = (RowExpression)dereferenceExpression.getArguments().get(0);
                    RowType baseType = (RowType)base.getType();
                    RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)dereferenceExpression.getArguments().get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                    if (indexExpression instanceof ConstantExpression && (index = ((ConstantExpression)indexExpression).getValue()) instanceof Number && (fieldName = ((RowType.Field)baseType.getFields().get(((Number)index).intValue())).getName()).isPresent()) {
                        elements.add(new Subfield.NestedField((String)fieldName.get()));
                        expression = base;
                        continue;
                    }
                    return Optional.empty();
                }
                if (!(expression instanceof CallExpression) || !functionResolution.isSubscriptFunction(((CallExpression)expression).getFunctionHandle())) break block5;
                List arguments = ((CallExpression)expression).getArguments();
                RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)arguments.get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                if (!(indexExpression instanceof ConstantExpression)) break;
                Object index = ((ConstantExpression)indexExpression).getValue();
                if (index instanceof Number) {
                    elements.add(new Subfield.LongSubscript(((Number)index).longValue()));
                    expression = (RowExpression)arguments.get(0);
                    continue;
                }
                if (!Varchars.isVarcharType((Type)indexExpression.getType())) break;
                elements.add(new Subfield.StringSubscript(((Slice)index).toStringUtf8()));
                expression = (RowExpression)arguments.get(0);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public RowExpression toRowExpression(Subfield subfield, Type columnType) {
        List path = subfield.getPath();
        ImmutableList.Builder types = ImmutableList.builder();
        types.add((Object)columnType);
        Type type = columnType;
        for (int i = 0; i < path.size(); ++i) {
            if (type instanceof RowType) {
                type = SubfieldExtractor.getFieldType((RowType)type, ((Subfield.NestedField)path.get(i)).getName());
                types.add((Object)type);
                continue;
            }
            if (type instanceof ArrayType) {
                type = ((ArrayType)type).getElementType();
                types.add((Object)type);
                continue;
            }
            if (type instanceof MapType) {
                type = ((MapType)type).getValueType();
                types.add((Object)type);
                continue;
            }
            Verify.verify((boolean)false, (String)("Unexpected type: " + type), (Object[])new Object[0]);
        }
        return this.toRowExpression(subfield, (List<Type>)types.build());
    }

    private RowExpression toRowExpression(Subfield subfield, List<Type> types) {
        List path = subfield.getPath();
        if (path.isEmpty()) {
            return new VariableReferenceExpression(Optional.empty(), subfield.getRootName(), types.get(0));
        }
        RowExpression base = this.toRowExpression(new Subfield(subfield.getRootName(), path.subList(0, path.size() - 1)), types.subList(0, types.size() - 1));
        Type baseType = types.get(types.size() - 2);
        Subfield.PathElement pathElement = (Subfield.PathElement)path.get(path.size() - 1);
        if (pathElement instanceof Subfield.LongSubscript) {
            BigintType indexType = baseType instanceof MapType ? ((MapType)baseType).getKeyType() : BigintType.BIGINT;
            FunctionHandle functionHandle = this.functionResolution.subscriptFunction(baseType, (Type)indexType);
            ConstantExpression index = new ConstantExpression(base.getSourceLocation(), (Object)((Subfield.LongSubscript)pathElement).getIndex(), (Type)indexType);
            return new CallExpression(base.getSourceLocation(), OperatorType.SUBSCRIPT.name(), functionHandle, types.get(types.size() - 1), (List)ImmutableList.of((Object)base, (Object)index));
        }
        if (pathElement instanceof Subfield.StringSubscript) {
            Type indexType = ((MapType)baseType).getKeyType();
            FunctionHandle functionHandle = this.functionResolution.subscriptFunction(baseType, indexType);
            ConstantExpression index = new ConstantExpression(base.getSourceLocation(), (Object)Slices.utf8Slice((String)((Subfield.StringSubscript)pathElement).getIndex()), indexType);
            return new CallExpression(base.getSourceLocation(), OperatorType.SUBSCRIPT.name(), functionHandle, types.get(types.size() - 1), (List)ImmutableList.of((Object)base, (Object)index));
        }
        if (pathElement instanceof Subfield.NestedField) {
            Subfield.NestedField nestedField = (Subfield.NestedField)pathElement;
            return new SpecialFormExpression(base.getSourceLocation(), SpecialFormExpression.Form.DEREFERENCE, types.get(types.size() - 1), new RowExpression[]{base, new ConstantExpression(base.getSourceLocation(), (Object)SubfieldExtractor.getFieldIndex((RowType)baseType, nestedField.getName()), (Type)IntegerType.INTEGER)});
        }
        Verify.verify((boolean)false, (String)("Unexpected path element: " + pathElement), (Object[])new Object[0]);
        return null;
    }

    private static Type getFieldType(RowType rowType, String fieldName) {
        for (RowType.Field field : rowType.getFields()) {
            Verify.verify((boolean)field.getName().isPresent());
            if (!((String)field.getName().get()).equals(fieldName)) continue;
            return field.getType();
        }
        Verify.verify((boolean)false, (String)("Unexpected field name: " + fieldName), (Object[])new Object[0]);
        return null;
    }

    private static long getFieldIndex(RowType rowType, String fieldName) {
        List fields = rowType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            RowType.Field field = (RowType.Field)fields.get(i);
            Verify.verify((boolean)field.getName().isPresent());
            if (!((String)field.getName().get()).equals(fieldName)) continue;
            return i;
        }
        Verify.verify((boolean)false, (String)("Unexpected field name: " + fieldName), (Object[])new Object[0]);
        return -1L;
    }
}

