/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.spi.ConnectorSession;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.write.ParquetRecordWriterWrapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetRecordWriter;

public final class ParquetRecordWriterUtil {
    private static final Field REAL_WRITER_FIELD;
    private static final Field INTERNAL_WRITER_FIELD;
    private static final Field FILE_WRITER_FIELD;

    private ParquetRecordWriterUtil() {
    }

    public static FileSinkOperator.RecordWriter createParquetWriter(final Path target, final JobConf conf, Properties properties, boolean compress, ConnectorSession session) throws IOException, ReflectiveOperationException {
        conf.setLong("parquet.block.size", HiveSessionProperties.getParquetWriterBlockSize(session).toBytes());
        conf.setLong("parquet.page.size", HiveSessionProperties.getParquetWriterPageSize(session).toBytes());
        final FileSinkOperator.RecordWriter recordWriter = new MapredParquetOutputFormat().getHiveRecordWriter(conf, target, Text.class, compress, properties, (Progressable)Reporter.NULL);
        Object realWriter = REAL_WRITER_FIELD.get(recordWriter);
        Object internalWriter = INTERNAL_WRITER_FIELD.get(realWriter);
        final ParquetFileWriter fileWriter = (ParquetFileWriter)FILE_WRITER_FIELD.get(internalWriter);
        return new RecordFileWriter.ExtendedRecordWriter(){
            private long length;

            @Override
            public long getWrittenBytes() {
                return this.length;
            }

            public void write(Writable value) throws IOException {
                recordWriter.write(value);
                this.length = fileWriter.getPos();
            }

            public void close(boolean abort) throws IOException {
                recordWriter.close(abort);
                if (!abort) {
                    this.length = target.getFileSystem((Configuration)conf).getFileStatus(target).getLen();
                }
            }
        };
    }

    static {
        try {
            REAL_WRITER_FIELD = ParquetRecordWriterWrapper.class.getDeclaredField("realWriter");
            INTERNAL_WRITER_FIELD = ParquetRecordWriter.class.getDeclaredField("internalWriter");
            FILE_WRITER_FIELD = INTERNAL_WRITER_FIELD.getType().getDeclaredField("parquetFileWriter");
            REAL_WRITER_FIELD.setAccessible(true);
            INTERNAL_WRITER_FIELD.setAccessible(true);
            FILE_WRITER_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

