/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Objects;
import java.util.Optional;

public class HiveReadOnlyException
extends PrestoException {
    private final SchemaTableName tableName;
    private final Optional<String> partition;

    public HiveReadOnlyException(SchemaTableName tableName, Optional<String> partition) {
        super((ErrorCodeSupplier)(partition.isPresent() ? HiveErrorCode.HIVE_PARTITION_READ_ONLY : HiveErrorCode.HIVE_TABLE_READ_ONLY), HiveReadOnlyException.composeMessage(tableName, partition));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
    }

    private static String composeMessage(SchemaTableName tableName, Optional<String> partition) {
        return partition.isPresent() ? String.format("Table '%s' partition '%s' is read-only", tableName, partition.get()) : String.format("Table '%s' is read-only", tableName);
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public Optional<String> getPartition() {
        return this.partition;
    }
}

