/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveConnectorFactory;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;

public class HivePlugin
implements Plugin {
    private final String name;
    private final Optional<ExtendedHiveMetastore> metastore;

    public HivePlugin(String name) {
        this(name, Optional.empty());
    }

    public HivePlugin(String name, Optional<ExtendedHiveMetastore> metastore) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new HiveConnectorFactory(this.name, HivePlugin.getClassLoader(), this.metastore));
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = HivePlugin.class.getClassLoader();
        }
        return classLoader;
    }
}

