/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class HivePartition {
    public static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    private final SchemaTableName tableName;
    private final String partitionId;
    private final Map<ColumnHandle, NullableValue> keys;

    public HivePartition(SchemaTableName tableName) {
        this(tableName, UNPARTITIONED_ID, (Map<ColumnHandle, NullableValue>)ImmutableMap.of());
    }

    public HivePartition(SchemaTableName tableName, String partitionId, Map<ColumnHandle, NullableValue> keys) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitionId = Objects.requireNonNull(partitionId, "partitionId is null");
        this.keys = ImmutableMap.copyOf(Objects.requireNonNull(keys, "keys is null"));
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public Map<ColumnHandle, NullableValue> getKeys() {
        return this.keys;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartition other = (HivePartition)obj;
        return Objects.equals(this.partitionId, other.partitionId);
    }

    public String toString() {
        return this.tableName + ":" + this.partitionId;
    }
}

