/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.presto.hive.ForUpdatingHiveMetadata;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveMetadataUpdater;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdater;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdaterProvider;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class HiveMetadataUpdaterProvider
implements ConnectorMetadataUpdaterProvider {
    private final ExecutorService executorService;
    private final Executor boundedExecutor;

    @Inject
    public HiveMetadataUpdaterProvider(@ForUpdatingHiveMetadata ExecutorService executorService, HiveClientConfig hiveClientConfig) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        int maxMetadataUpdaterThreads = Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null").getMaxMetadataUpdaterThreads();
        this.boundedExecutor = new BoundedExecutor((Executor)executorService, maxMetadataUpdaterThreads);
    }

    public ConnectorMetadataUpdater getMetadataUpdater() {
        return new HiveMetadataUpdater(this.boundedExecutor);
    }

    @PreDestroy
    public void stop() {
        this.executorService.shutdownNow();
    }
}

