/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Managed;

public class HiveFileRenamer {
    private final Map<QueryId, Map<HiveMetadataUpdateKey, AtomicLong>> queryPartitionFileCounterMap = new ConcurrentHashMap<QueryId, Map<HiveMetadataUpdateKey, AtomicLong>>();
    private final Map<QueryId, Map<HiveMetadataUpdateHandle, String>> queryHiveMetadataResultMap = new ConcurrentHashMap<QueryId, Map<HiveMetadataUpdateHandle, String>>();

    public List<ConnectorMetadataUpdateHandle> getMetadataUpdateResults(List<ConnectorMetadataUpdateHandle> metadataUpdateRequests, QueryId queryId) {
        ImmutableList.Builder metadataUpdateResults = ImmutableList.builder();
        for (ConnectorMetadataUpdateHandle connectorMetadataUpdateHandle : metadataUpdateRequests) {
            HiveMetadataUpdateHandle request = (HiveMetadataUpdateHandle)connectorMetadataUpdateHandle;
            String fileName = this.getFileName(request, queryId);
            metadataUpdateResults.add((Object)new HiveMetadataUpdateHandle(request.getRequestId(), request.getSchemaTableName(), request.getPartitionName(), Optional.of(fileName)));
        }
        return metadataUpdateResults.build();
    }

    public void cleanup(QueryId queryId) {
        this.queryPartitionFileCounterMap.remove(queryId);
        this.queryHiveMetadataResultMap.remove(queryId);
    }

    private String getFileName(HiveMetadataUpdateHandle request, QueryId queryId) {
        if (!this.queryPartitionFileCounterMap.containsKey(queryId) || !this.queryHiveMetadataResultMap.containsKey(queryId)) {
            this.queryPartitionFileCounterMap.putIfAbsent(queryId, new ConcurrentHashMap());
            this.queryHiveMetadataResultMap.putIfAbsent(queryId, new ConcurrentHashMap());
        }
        Map<HiveMetadataUpdateKey, AtomicLong> partitionFileCounterMap = this.queryPartitionFileCounterMap.get(queryId);
        Map<HiveMetadataUpdateHandle, String> hiveMetadataResultMap = this.queryHiveMetadataResultMap.get(queryId);
        if (hiveMetadataResultMap.containsKey(request)) {
            return hiveMetadataResultMap.get(request);
        }
        HiveMetadataUpdateKey key = new HiveMetadataUpdateKey(request);
        partitionFileCounterMap.putIfAbsent(key, new AtomicLong(0L));
        AtomicLong fileCount = partitionFileCounterMap.get(key);
        String fileName = Long.valueOf(fileCount.getAndIncrement()).toString();
        hiveMetadataResultMap.put(request, fileName);
        return fileName;
    }

    @PreDestroy
    public void stop() {
        Verify.verify((boolean)this.queryPartitionFileCounterMap.isEmpty(), (String)"Query partition file counter map has %s entries left behind", (int)this.queryPartitionFileCounterMap.size());
        Verify.verify((boolean)this.queryHiveMetadataResultMap.isEmpty(), (String)"Query hive metadata result map has %s entries left behind", (int)this.queryHiveMetadataResultMap.size());
    }

    @Managed
    public int getQueryPartitionFileCounterMapSize() {
        return this.queryPartitionFileCounterMap.size();
    }

    private static class HiveMetadataUpdateKey {
        private final SchemaTableName schemaTableName;
        private final Optional<String> partitionName;

        private HiveMetadataUpdateKey(HiveMetadataUpdateHandle hiveMetadataUpdateHandle) {
            this.schemaTableName = hiveMetadataUpdateHandle.getSchemaTableName();
            this.partitionName = hiveMetadataUpdateHandle.getPartitionName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HiveMetadataUpdateKey o = (HiveMetadataUpdateKey)obj;
            return this.schemaTableName.equals((Object)o.schemaTableName) && this.partitionName.equals(o.partitionName);
        }

        public int hashCode() {
            return Objects.hash(this.schemaTableName, this.partitionName);
        }
    }
}

