/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.policy.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class ThrottlingPool {
    private static final Map<String, Entity> map = new ConcurrentHashMap<String, Entity>();
    private static final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("throttling-pool-%d").daemon(true).build());

    public static synchronized void put(String key, Object data) {
        ThrottlingPool.put(key, data, -1);
    }

    public static synchronized void put(final String key, Object data, int expire) {
        ThrottlingPool.remove(key);
        if (data != null) {
            if (expire >= 0) {
                ScheduledFuture<?> future = executor.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<ThrottlingPool> clazz = ThrottlingPool.class;
                        synchronized (ThrottlingPool.class) {
                            map.remove(key);
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, (long)expire, TimeUnit.MILLISECONDS);
                map.put(key, new Entity(data, expire, future));
            } else {
                map.put(key, new Entity(data, expire, null));
            }
        }
    }

    public static synchronized Object get(String key) {
        Entity entity = map.get(key);
        return entity != null ? entity.getValue() : null;
    }

    public static synchronized <T> T get(String key, Class<T> clazz) {
        return clazz.cast(ThrottlingPool.get(key));
    }

    public static synchronized int getExpire(String key) {
        Entity entity = map.get(key);
        return entity != null ? entity.getExpire() : 0;
    }

    public static synchronized Object remove(String key) {
        Entity entity = map.remove(key);
        if (entity == null) {
            return null;
        }
        Future<?> future = entity.getFuture();
        if (future != null) {
            future.cancel(true);
        }
        return entity.getValue();
    }

    public static synchronized int size() {
        return map.size();
    }

    public static synchronized void clear() {
        for (Entity entity : map.values()) {
            Future<?> future;
            if (entity == null || (future = entity.getFuture()) == null) continue;
            future.cancel(true);
        }
        map.clear();
    }

    public static synchronized Map<String, Entity> getPool() {
        return map;
    }

    private static class Entity {
        private Object value;
        private int expire;
        private Future<?> future;

        public Entity(Object value, int expire, Future<?> future) {
            this.value = value;
            this.expire = expire;
            this.future = future;
        }

        public Object getValue() {
            return this.value;
        }

        public int getExpire() {
            return this.expire;
        }

        public Future<?> getFuture() {
            return this.future;
        }
    }
}

