/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth.signers;

import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.Signer;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class HmacSM3Signer
extends Signer {
    public static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "HMAC-SM3";
    private static String HASH_SM3 = "SM3";

    @Override
    public String signString(String stringToSign, String accessKeySecret) {
        try {
            SecretKeySpec key = new SecretKeySpec(accessKeySecret.getBytes(ENCODING), ALGORITHM_NAME);
            HMac mac = new HMac((Digest)new SM3Digest());
            byte[] sign = new byte[mac.getMacSize()];
            byte[] inputBytes = stringToSign.getBytes(ENCODING);
            mac.init((CipherParameters)new KeyParameter(key.getEncoded()));
            mac.update(inputBytes, 0, inputBytes.length);
            mac.doFinal(sign, 0);
            return AcsURLEncoder.hexEncode(sign);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public String signString(String stringToSign, AlibabaCloudCredentials credentials) {
        return this.signString(stringToSign, credentials.getAccessKeySecret());
    }

    @Override
    public String getSignerName() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getSignerVersion() {
        return "3.0";
    }

    @Override
    public String getSignerType() {
        return null;
    }

    @Override
    public byte[] hash(byte[] raw) throws NoSuchAlgorithmException {
        if (null == raw) {
            return null;
        }
        BouncyCastleProvider provider = new BouncyCastleProvider();
        MessageDigest digest = MessageDigest.getInstance(HASH_SM3, (Provider)provider);
        return digest.digest(raw);
    }

    @Override
    public String getContent() {
        return "x-acs-content-sm3";
    }
}

