/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AnonymousCredentials;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.auth.BearerTokenCredentials;
import com.aliyuncs.auth.KeyPairCredentials;
import com.aliyuncs.auth.RpcSignatureComposer;
import com.aliyuncs.auth.SignatureVersion;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.utils.ParameterHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public abstract class RpcAcsRequest<T extends AcsResponse>
extends AcsRequest<T> {
    public RpcAcsRequest(String product) {
        super(product);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action) {
        super(product);
        this.setSysVersion(version);
        this.setSysActionName(action);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, SignatureVersion signatureVersion) {
        super(product);
        this.setSysVersion(version);
        this.setSysActionName(action);
        this.setSysSignatureVersion(signatureVersion);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, String locationProduct) {
        super(product);
        this.setSysVersion(version);
        this.setSysActionName(action);
        this.setSysLocationProduct(locationProduct);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, String locationProduct, SignatureVersion signatureVersion) {
        super(product);
        this.setSysVersion(version);
        this.setSysActionName(action);
        this.setSysLocationProduct(locationProduct);
        this.setSysSignatureVersion(signatureVersion);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, String locationProduct, String endpointType) {
        super(product);
        this.setSysVersion(version);
        this.setSysActionName(action);
        this.setSysLocationProduct(locationProduct);
        this.setSysEndpointType(endpointType);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, String locationProduct, String endpointType, SignatureVersion signatureVersion) {
        super(product);
        this.setSysVersion(version);
        this.setSysActionName(action);
        this.setSysLocationProduct(locationProduct);
        this.setSysEndpointType(endpointType);
        this.setSysSignatureVersion(signatureVersion);
        this.initialize();
    }

    private void initialize() {
        this.setSysMethod(MethodType.GET);
        this.setSysAcceptFormat(FormatType.JSON);
        this.setHttpContentType(FormatType.FORM);
        this.composer = RpcSignatureComposer.getComposer();
    }

    @Override
    public void setActionName(String actionName) {
        super.setActionName(actionName);
        this.putQueryParameter("Action", actionName);
    }

    @Override
    public void setVersion(String version) {
        super.setVersion(version);
        this.putQueryParameter("Version", version);
    }

    @Override
    public void setSecurityToken(String securityToken) {
        super.setSecurityToken(securityToken);
        this.putQueryParameter("SecurityToken", securityToken);
    }

    @Override
    public void setAcceptFormat(FormatType acceptFormat) {
        super.setAcceptFormat(acceptFormat);
        this.putQueryParameter("Format", acceptFormat.toString());
    }

    @Override
    public void setSysActionName(String actionName) {
        super.setSysActionName(actionName);
        this.putQueryParameter("Action", actionName);
    }

    @Override
    public void setSysVersion(String version) {
        super.setSysVersion(version);
        this.putQueryParameter("Version", version);
    }

    @Override
    public void setSysAcceptFormat(FormatType acceptFormat) {
        super.setSysAcceptFormat(acceptFormat);
        this.putQueryParameter("Format", acceptFormat.toString());
    }

    @Override
    public void setSysSecurityToken(String securityToken) {
        super.setSysSecurityToken(securityToken);
        this.putQueryParameter("SecurityToken", securityToken);
    }

    @Override
    public String composeUrl(String endpoint, Map<String, String> queries) throws UnsupportedEncodingException {
        Map<String, String> mapQueries = queries == null ? this.getSysQueryParameters() : queries;
        StringBuilder urlBuilder = new StringBuilder("");
        urlBuilder.append(this.getSysProtocol().toString());
        urlBuilder.append("://").append(endpoint);
        if (-1 == urlBuilder.indexOf("?")) {
            urlBuilder.append("/?");
        }
        String query = RpcAcsRequest.concatQueryString(mapQueries);
        return urlBuilder.append(query).toString();
    }

    @Override
    public HttpRequest signRequest(Signer signer, AlibabaCloudCredentials credentials, FormatType format, ProductDomain domain) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException {
        this.resolveSignatureComposer();
        Map<String, String> headerMap = new HashMap<String, String>();
        Map<String, String> bodyParams = this.getSysBodyParameters();
        String hashedRequestPayload = AcsURLEncoder.hexEncode(signer != null ? signer.hash("".getBytes("UTF-8")) : null);
        if (bodyParams != null && !bodyParams.isEmpty()) {
            byte[] data = FormatType.JSON == this.getHttpContentType() ? ParameterHelper.getJsonData(bodyParams) : (FormatType.XML == this.getHttpContentType() ? ParameterHelper.getXmlData(bodyParams) : ParameterHelper.getFormData(bodyParams));
            this.setHttpContent(data, "UTF-8", null);
            hashedRequestPayload = AcsURLEncoder.hexEncode(signer != null ? signer.hash(data) : null);
        }
        Map<String, String> imutableMap = this.composer.refreshSignParameters(this.getSysQueryParameters(), signer, null, format);
        headerMap.putAll(this.getSysHeaders());
        headerMap = this.composer.refreshSignParameters(headerMap, signer, null, null);
        if (!(imutableMap.get("RegionId") != null || this.getSysRegionId() == null || this.getSysRegionId().equals("") || bodyParams != null && bodyParams.get("RegionId") != null)) {
            imutableMap.put("RegionId", this.getSysRegionId());
        }
        if (null != signer && null != credentials && !(credentials instanceof AnonymousCredentials)) {
            String sessionToken;
            String accessKeyId = credentials.getAccessKeyId();
            String accessSecret = credentials.getAccessKeySecret();
            if (credentials instanceof BasicSessionCredentials && null != (sessionToken = ((BasicSessionCredentials)credentials).getSessionToken())) {
                imutableMap.put("SecurityToken", sessionToken);
                headerMap.put("x-acs-security-token", sessionToken);
            }
            if (credentials instanceof BearerTokenCredentials) {
                String bearerToken = ((BearerTokenCredentials)credentials).getBearerToken();
                if (null != ((BearerTokenCredentials)credentials).getBearerToken()) {
                    imutableMap.put("BearerToken", bearerToken);
                    headerMap.put("x-acs-bearer-token", bearerToken);
                }
            }
            if (signer.getContent() != null && hashedRequestPayload != null) {
                headerMap.put(signer.getContent(), hashedRequestPayload);
            }
            HashMap<String, String> paramsToSign = new HashMap<String, String>();
            paramsToSign.putAll(bodyParams);
            imutableMap.put("AccessKeyId", accessKeyId);
            paramsToSign.putAll(imutableMap);
            if (this.getSysSignatureVersion() == SignatureVersion.V3) {
                String strToSign;
                this.strToSign = strToSign = this.composer.composeStringToSign(this.getSysMethod(), null, signer, paramsToSign, headerMap, null) + "\n" + hashedRequestPayload;
                strToSign = signer.getSignerName() + "\n" + AcsURLEncoder.hexEncode(signer.hash(strToSign.getBytes("UTF-8")));
                String signature = signer.signString(strToSign, accessSecret);
                headerMap.put("Authorization", this.composer.getAuthorization(signer, accessKeyId, signature) + ",SignedHeaders=" + this.getSysSignedHeaders(imutableMap));
                imutableMap = this.getSysQueryParameters();
            } else {
                String strToSign;
                this.strToSign = strToSign = this.composer.composeStringToSign(this.getSysMethod(), null, signer, paramsToSign, null, null);
                String signature = credentials instanceof KeyPairCredentials ? signer.signString(strToSign, credentials) : signer.signString(strToSign, accessSecret + "&");
                imutableMap.put("Signature", this.composer.getAuthorization(signer, accessKeyId, signature));
                headerMap.clear();
                headerMap.putAll(this.getSysHeaders());
            }
        }
        this.setSysUrl(this.composeUrl(domain.getDomainName(), imutableMap));
        this.headers = headerMap;
        return this;
    }
}

