/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.CommonRoaRequest;
import com.aliyuncs.CommonRpcRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.regions.ProductDomain;
import java.util.HashMap;
import java.util.Map;

public class CommonRequest {
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> bodyParameters = new HashMap<String, String>();
    private final Map<String, String> headParameters = new HashMap<String, String>();
    private String version = null;
    private String product = null;
    private String action = null;
    private String locationProduct = null;
    private String endpointType = null;
    private String regionId = null;
    private ProtocolType protocol = null;
    private Integer connectTimeout = null;
    private Integer readTimeout = null;
    private MethodType method = null;
    private FormatType httpContentType = null;
    private byte[] httpContent = null;
    private String encoding = null;
    private String uriPattern = null;
    private Map<String, String> pathParameters = new HashMap<String, String>();
    private String domain = null;

    public AcsRequest buildRequest() {
        if (this.uriPattern != null) {
            CommonRoaRequest request = new CommonRoaRequest(this.product);
            request.setSysUriPattern(this.uriPattern);
            for (String pathParamKey : this.pathParameters.keySet()) {
                request.putPathParameter(pathParamKey, this.pathParameters.get(pathParamKey));
            }
            this.fillParams(request);
            return request;
        }
        CommonRpcRequest request = new CommonRpcRequest(this.product);
        this.fillParams(request);
        return request;
    }

    private void fillParams(AcsRequest request) {
        request.putHeaderParameter("x-sdk-invoke-type", "common");
        if (this.version != null) {
            request.setSysVersion(this.version);
        }
        if (this.action != null) {
            request.setSysActionName(this.action);
        }
        if (this.regionId != null) {
            request.setSysRegionId(this.regionId);
        }
        if (this.locationProduct != null) {
            request.setSysLocationProduct(this.locationProduct);
        }
        if (this.endpointType != null) {
            request.setSysEndpointType(this.endpointType);
        }
        if (this.connectTimeout != null) {
            request.setSysConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            request.setSysReadTimeout(this.readTimeout);
        }
        if (this.method != null) {
            request.setSysMethod(this.method);
        }
        if (this.protocol != null) {
            request.setSysProtocol(this.protocol);
        }
        if (this.domain != null) {
            ProductDomain productDomain = new ProductDomain(this.product, this.domain);
            request.setSysProductDomain(productDomain);
        }
        if (this.httpContent != null) {
            request.setHttpContent(this.httpContent, this.encoding, this.httpContentType);
        }
        for (String queryParamKey : this.queryParameters.keySet()) {
            request.putQueryParameter(queryParamKey, this.queryParameters.get(queryParamKey));
        }
        for (String bodyParamKey : this.bodyParameters.keySet()) {
            request.putBodyParameter(bodyParamKey, this.bodyParameters.get(bodyParamKey));
        }
        for (String headParamKey : this.headParameters.keySet()) {
            request.putHeaderParameter(headParamKey, this.headParameters.get(headParamKey));
        }
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public String getProduct() {
        return this.product;
    }

    @Deprecated
    public void setProduct(String product) {
        this.product = product;
    }

    @Deprecated
    public String getAction() {
        return this.action;
    }

    @Deprecated
    public void setAction(String action) {
        this.action = action;
    }

    @Deprecated
    public String getLocationProduct() {
        return this.locationProduct;
    }

    @Deprecated
    public void setLocationProduct(String locationProduct) {
        this.locationProduct = locationProduct;
    }

    @Deprecated
    public String getEndpointType() {
        return this.endpointType;
    }

    @Deprecated
    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    @Deprecated
    public String getRegionId() {
        return this.regionId;
    }

    @Deprecated
    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    @Deprecated
    public ProtocolType getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public void setProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public void putBodyParameter(String name, Object value) {
        this.setParameter(this.bodyParameters, name, value);
    }

    public void putQueryParameter(String name, String value) {
        this.setParameter(this.queryParameters, name, value);
    }

    public void putHeadParameter(String name, String value) {
        this.setParameter(this.headParameters, name, value);
    }

    private void setParameter(Map<String, String> map, String name, Object value) {
        if (null == map || name == null || value == null) {
            return;
        }
        map.put(name, String.valueOf(value));
    }

    @Deprecated
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Deprecated
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Deprecated
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Deprecated
    public MethodType getMethod() {
        return this.method;
    }

    @Deprecated
    public void setMethod(MethodType method) {
        this.method = method;
    }

    @Deprecated
    public String getUriPattern() {
        return this.uriPattern;
    }

    @Deprecated
    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void putPathParameter(String name, String value) {
        this.setParameter(this.pathParameters, name, value);
    }

    @Deprecated
    public String getDomain() {
        return this.domain;
    }

    @Deprecated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public FormatType getHttpContentType() {
        return this.httpContentType;
    }

    public byte[] getHttpContent() {
        return this.httpContent;
    }

    @Deprecated
    public String getEncoding() {
        return this.encoding;
    }

    @Deprecated
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Deprecated
    public Map<String, String> getBodyParameters() {
        return this.bodyParameters;
    }

    @Deprecated
    public Map<String, String> getHeadParameters() {
        return this.headParameters;
    }

    @Deprecated
    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public void setHttpContent(byte[] content, String encoding, FormatType format) {
        if (content == null || encoding == null || format == null) {
            return;
        }
        this.httpContent = content;
        this.httpContentType = format;
        this.encoding = encoding;
    }

    public String getSysVersion() {
        return this.version;
    }

    public void setSysVersion(String version) {
        this.version = version;
    }

    public String getSysProduct() {
        return this.product;
    }

    public void setSysProduct(String product) {
        this.product = product;
    }

    public String getSysAction() {
        return this.action;
    }

    public void setSysAction(String action) {
        this.action = action;
    }

    public String getSysLocationProduct() {
        return this.locationProduct;
    }

    public void setSysLocationProduct(String locationProduct) {
        this.locationProduct = locationProduct;
    }

    public String getSysEndpointType() {
        return this.endpointType;
    }

    public void setSysEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public String getSysRegionId() {
        return this.regionId;
    }

    public void setSysRegionId(String regionId) {
        this.regionId = regionId;
    }

    public ProtocolType getSysProtocol() {
        return this.protocol;
    }

    public void setSysProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public Integer getSysConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSysConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSysReadTimeout() {
        return this.readTimeout;
    }

    public void setSysReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public MethodType getSysMethod() {
        return this.method;
    }

    public void setSysMethod(MethodType method) {
        this.method = method;
    }

    public String getSysUriPattern() {
        return this.uriPattern;
    }

    public void setSysUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public String getSysDomain() {
        return this.domain;
    }

    public void setSysDomain(String domain) {
        this.domain = domain;
    }

    public String getSysEncoding() {
        return this.encoding;
    }

    public Map<String, String> getSysQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getSysBodyParameters() {
        return this.bodyParameters;
    }

    public Map<String, String> getSysHeadParameters() {
        return this.headParameters;
    }

    public Map<String, String> getSysPathParameters() {
        return this.pathParameters;
    }
}

