/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.http;

import com.aliyun.auth.credentials.http.HttpMessage;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.core.utils.Configuration;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class HttpRequest
extends HttpMessage {
    private Map<String, String> immutableMap = new HashMap<String, String>();
    private static final String DEFAULT_USER_AGENT;

    public HttpRequest() {
        this.setCommonParameter();
    }

    public HttpRequest(String url) {
        super(url);
        this.setCommonParameter();
    }

    private void setCommonParameter() {
        this.immutableMap.put("Timestamp", ParameterHelper.getISO8601Time(new Date()));
        this.immutableMap.put("SignatureNonce", ParameterHelper.getUniqueNonce());
        this.immutableMap.put("SignatureMethod", "HMAC-SHA1");
        this.immutableMap.put("SignatureVersion", "1.0");
        this.putHeaderParameter("user-agent", DEFAULT_USER_AGENT);
    }

    public void setUrlParameter(String key, String value) {
        this.immutableMap.put(key, value);
    }

    public String getUrlParameter(String key) {
        return this.immutableMap.get(key);
    }

    public Map<String, String> getUrlParameters() {
        return Collections.unmodifiableMap(this.immutableMap);
    }

    static {
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osArch = Configuration.getGlobalConfiguration().get("os.arch");
        String coreVersion = "unknown";
        try {
            Properties props = new Properties();
            props.load(HttpRequest.class.getClassLoader().getResourceAsStream("core.properties"));
            coreVersion = props.getProperty("sdk.project.version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEFAULT_USER_AGENT = String.format("AlibabaCloud (%s; %s) Java/%s AsyncCredentials/%s TeaDSL/1", "AlibabaCloud", osName, osArch, javaVersion, "AsyncCoreService", coreVersion);
    }
}

