/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class BindPhoneRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="DeviceId")
    @Validation(required=true)
    private String deviceId;
    @Query
    @NameInMap(value="PhoneNumber")
    @Validation(required=true)
    private String phoneNumber;

    private BindPhoneRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.deviceId = builder.deviceId;
        this.phoneNumber = builder.phoneNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BindPhoneRequest create() {
        return BindPhoneRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public static final class Builder
    extends Request.Builder<BindPhoneRequest, Builder> {
        private Long appKey;
        private String deviceId;
        private String phoneNumber;

        private Builder() {
        }

        private Builder(BindPhoneRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.deviceId = request.deviceId;
            this.phoneNumber = request.phoneNumber;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.putQueryParameter("DeviceId", deviceId);
            this.deviceId = deviceId;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.putQueryParameter("PhoneNumber", phoneNumber);
            this.phoneNumber = phoneNumber;
            return this;
        }

        public BindPhoneRequest build() {
            return new BindPhoneRequest(this);
        }
    }
}

