/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugin.flexible;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.common.tracer.core.utils.TracerUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class FlexibleStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    public FlexibleStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        statKey.addKey("local.app", (String)tagsWithStr.get("local.app"));
        statKey.addKey("method", (String)tagsWithStr.get("method"));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        String error = (String)tagsWithStr.get(Tags.ERROR.getKey());
        statKey.setResult(StringUtils.isBlank((String)error) ? "Y" : "N");
        statKey.setEnd(TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }
}

