/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource.utils;

import com.alipay.common.tracer.core.utils.StringUtils;

public class SqlUtils {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String DEFAULT_SEPARATOR_ESCAPE = "%2C";
    private static final String DEFAULT_NEW_LINE = "\n";
    private static final String DEFAULT_RETURN = "\r";
    private static final String EMPTY_STRING = "";
    private static final int DIGEST_LOG_SQL_LIMIT = 4096;

    public static String getSqlEscaped(String sql) {
        String limitSql = sql;
        if (limitSql != null && limitSql.length() > 4096) {
            limitSql = limitSql.substring(0, 4096) + " ...";
        }
        return SqlUtils.escape(SqlUtils.escapeWithSpecialCheck(limitSql), DEFAULT_SEPARATOR, DEFAULT_SEPARATOR_ESCAPE);
    }

    private static String escape(String str, String oldStr, String newStr) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return StringUtils.replace((String)str, (String)oldStr, (String)newStr);
    }

    private static String escapeWithSpecialCheck(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        StringBuilder appender = new StringBuilder();
        int len = str.length();
        appender.ensureCapacity(appender.length() + len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\n' || c == '\r' || c == '|') {
                c = ' ';
            }
            if (c == ' ' && (c != 32 || appender.length() <= 0 || appender.charAt(appender.length() - 1) == ' ')) continue;
            appender.append(c);
        }
        return appender.toString().trim();
    }
}

