/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource.tracer;

import com.alipay.sofa.tracer.plugins.datasource.Interceptor;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceClientTracer;

public class StatementTracerInterceptor
implements Interceptor {
    private DataSourceClientTracer clientTracer;

    public void setClientTracer(DataSourceClientTracer clientTracer) {
        this.clientTracer = clientTracer;
    }

    @Override
    public Object intercept(Interceptor.Chain chain) throws Exception {
        long start = System.currentTimeMillis();
        String resultCode = "success";
        try {
            this.clientTracer.startTrace(chain.getOriginalSql());
            Object object = chain.proceed();
            return object;
        }
        catch (Exception e) {
            resultCode = "failed";
            throw e;
        }
        finally {
            this.clientTracer.endTrace(System.currentTimeMillis() - start, resultCode);
        }
    }
}

