/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource.tracer;

import java.util.HashMap;
import java.util.Map;

public class DataSourceTracerState {
    private static final int NEW = 0;
    private static final int PROCESSING_FIRST_SQL = 1;
    private int state = 0;
    private final Map<String, Object> traceState = new HashMap<String, Object>(8);

    DataSourceTracerState() {
        this.submit("start.time", System.currentTimeMillis());
    }

    public void submit(String key, Object value) {
        this.traceState.put(key, value);
    }

    public Object getValue(String key) {
        return this.traceState.get(key);
    }

    public int getState() {
        return this.state;
    }

    public void connectionEstablished() {
        Long startTime = (Long)this.traceState.get("start.time");
        this.submit("connection.establish.span", System.currentTimeMillis() - startTime);
    }

    public void propagate() {
        ++this.state;
    }

    public boolean isProcessingFirstSql() {
        return this.state == 1;
    }
}

